package com.bxm.component.office.excel.export.setting;

import java.util.List;


import com.google.common.collect.Lists;

/**
 * 功能说明：<br/>
 * excel导出配置信息
 * <br/>
 * 开发人员：liuj(liujia1@strongit.com.cn)<br/>
 * 开发时间：2016年3月1日<br/>
 */
public class ExportSetting {
    /**
     * excel sheet页
     */
    private List<ExcelSheet> sheets = Lists.newArrayList();

    /**
     * 添加sheet页
     * @param sheet sheet页内容与设置
     * @return this
     */
    public ExportSetting addSheet(ExcelSheet sheet){
        sheets.add(sheet);
        return this;
    }

    /**
     * 创建一个新的sheet页并添加到配置信息中
     * @return 新的sheet页
     */
    public ExcelSheet addSheet(){
        ExcelSheet sheet =  new ExcelSheet();
        sheets.add(sheet);
        return sheet;
    }

    public List<ExcelSheet> getSheets() {
        return sheets;
    }
}
