/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.component.office.excel.parse.impl;

import com.bxm.component.office.excel.format.CellValueConvertContext;
import com.bxm.component.office.excel.format.CellValueManage;
import com.bxm.component.office.excel.parse.ExcelParser;
import com.bxm.component.office.excel.parse.setting.ParseHeader;
import com.bxm.component.office.excel.parse.setting.ParseSetting;
import com.bxm.component.office.exception.ParseException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractExcelParser<T>
implements ExcelParser<T> {
    protected Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    protected Sheet sheet;
    protected ParseSetting setting;
    protected CellValueManage cellValueManage;
    private Workbook workbook;
    private File excelFile;
    private InputStream excelInputStream;

    @Override
    public CellValueManage getCellValueManage() {
        return this.cellValueManage;
    }

    @Override
    @Autowired
    public void setCellValueManage(CellValueManage cellValueManage) {
        this.cellValueManage = cellValueManage;
    }

    @Override
    public List<T> parse(File excelFile, ParseSetting setting) {
        this.setting = setting;
        this.excelFile = excelFile;
        this.init();
        return this.parseSheet();
    }

    @Override
    public List<T> parse(InputStream inputStream, ParseSetting setting) {
        this.setting = setting;
        this.excelInputStream = inputStream;
        this.init();
        return this.parseSheet();
    }

    private void init() {
        this.assertSetting();
        try {
            this.workbook = this.createWorkbook();
            this.sheet = this.workbook.getSheetAt(0);
            this.getContext().setWorkbook(this.workbook);
            this.getContext().setSheet(this.sheet);
            this.getContext().addExtend("PARSE_SETTING", this.setting);
        }
        catch (IOException e) {
            this.LOGGER.error(e.getMessage(), (Throwable)e);
            throw new ParseException(e);
        }
    }

    protected abstract List<T> parseSheet();

    private void assertSetting() {
        if (null == this.setting) {
            throw new IllegalArgumentException("setting can not be null");
        }
        if (null == this.excelFile && null == this.excelInputStream) {
            throw new IllegalArgumentException("excelFile can not be null");
        }
        if (null == this.setting.getEntityClasz()) {
            throw new IllegalArgumentException("entityClasz can not be null");
        }
        if (null == this.setting.getHeads()) {
            throw new IllegalArgumentException("setting.heads can not be null");
        }
        for (ParseHeader header : this.setting.getHeads()) {
            if (!this.setting.isHeaderModel()) {
                if (header.getColIndex() >= 0) continue;
                throw new IllegalArgumentException("in the index model,colIndex must be greater than zero");
            }
            if (!StringUtils.isBlank((CharSequence)header.getTitle())) continue;
            throw new IllegalArgumentException("in the title model,title must has text");
        }
    }

    protected CellValueConvertContext getContext() {
        return this.cellValueManage.getContext();
    }

    private boolean isExcel2003() {
        return StringUtils.endsWith((CharSequence)this.excelFile.getName(), (CharSequence)".xls");
    }

    protected boolean isExcel() {
        return this.excelFile != null && (StringUtils.endsWith((CharSequence)this.excelFile.getName(), (CharSequence)".xls") || StringUtils.endsWith((CharSequence)this.excelFile.getName(), (CharSequence)".xlsx"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Workbook createWorkbook() throws IOException {
        InputStream is = null;
        is = null != this.excelInputStream ? this.excelInputStream : FileUtils.openInputStream((File)this.excelFile);
        Object workbook = null;
        if (this.isExcel()) {
            workbook = this.isExcel2003() ? new HSSFWorkbook(is) : new XSSFWorkbook(is);
        } else {
            try {
                workbook = new HSSFWorkbook(is);
            }
            finally {
                if (null == workbook) {
                    try {
                        workbook = new XSSFWorkbook(is);
                    }
                    catch (Exception e) {
                        this.LOGGER.warn("\u8f93\u5165\u7684\u6587\u4ef6\u683c\u5f0f\u6216\u6d41\u4e0d\u662f\u4e00\u4e2a\u6709\u6548\u7684Excel\u6587\u4ef6");
                    }
                }
            }
        }
        return workbook;
    }
}

