/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.component.office.excel.format.impl;

import com.bxm.component.office.excel.format.config.CellTypeEnum;
import com.bxm.component.office.excel.format.impl.AbstractCellConverter;

public class BooleanCellConverter
extends AbstractCellConverter {
    @Override
    public boolean isMatch(CellTypeEnum cellType) {
        return CellTypeEnum.BOOLEAN.equals((Object)cellType);
    }

    @Override
    public void setValue() {
        Object trueLabel = this.getContext().getExtend("BOOLEAN_TRUE_LABEL");
        Object falseLabel = this.getContext().getExtend("BOOLEAN_FALSE_LABEL");
        if (null == trueLabel) {
            trueLabel = "\u662f";
        }
        if (null == falseLabel) {
            falseLabel = "\u5426";
        }
        Object value = this.getSetValue();
        boolean setValue = false;
        if (null != value) {
            if (value.getClass().isAssignableFrom(Boolean.TYPE) || value.getClass().isAssignableFrom(Boolean.class)) {
                setValue = (Boolean)value;
            } else {
                this.logger.warn("\u8f6c\u6362\u7684\u5b57\u6bb5\u503c\u4e0d\u662fboolean\u7c7b\u578b\uff0c\u5c06\u88ab\u8bbe\u7f6e\u4e3afalse");
            }
        }
        this.getCell().setCellValue(setValue ? trueLabel.toString() : falseLabel.toString());
    }

    @Override
    public Object getValue() {
        Object trueLabel;
        int cellType = this.getCellType();
        String cellValue = null;
        if (cellType == 1) {
            cellValue = this.getCell().getStringCellValue();
        }
        return null != (trueLabel = this.getContext().getExtend("BOOLEAN_TRUE_LABEL")) && trueLabel.toString().equals(cellValue) || "on".equalsIgnoreCase(cellValue) || "\u662f".equals(cellValue);
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

