package com.bxm.component.office.excel.export.setting;

import com.bxm.component.office.excel.format.config.CellTypeEnum;
import com.google.common.collect.Maps;

import java.util.Map;

/**
 * 功能说明：<br/>
 * excel sheet构建表头参数类
 * <br/>
 * 开发人员：liuj(liujia1@strongit.com.cn)<br/>
 * 开发时间：2016年3月1日<br/>
 */
public class SheetHeader {

    /**
     * 列标题
     */
    private String title;

    /**
     * 从数据结果集中进行映射的属性名
     */
    private String field;

    /**
     * 当前列的数据类型，默认为String
     */
    private CellTypeEnum cellType = CellTypeEnum.STRING;

    /**
     * 列宽度，不设置将默认设置列宽为自动
     * 注意：宽度已经转换为字符宽度，即设置数字 * 256
     */
    private int width;

    private Map<String, Object> expend;

    public SheetHeader() {
        super();
    }

    public SheetHeader(String title) {
        super();
        this.title = title;
    }

    public SheetHeader(String title, String field) {
        super();
        this.title = title;
        this.field = field;
    }

    public SheetHeader(String title, String field, int width) {
        super();
        this.title = title;
        this.field = field;
        this.width = width;
    }

    public SheetHeader(String title, String field, int width, CellTypeEnum cellType) {
        super();
        this.title = title;
        this.field = field;
        this.cellType = cellType;
        this.width = width;
    }

    public SheetHeader(String title, String field, CellTypeEnum cellType) {
        super();
        this.title = title;
        this.field = field;
        this.cellType = cellType;
    }

    public SheetHeader addExtpend(String key, Object value) {
        if (expend == null) {
            expend = Maps.newHashMap();
        }
        expend.put(key, value);
        return this;
    }

    public Map<String, Object> getExtpend() {
        return expend;
    }

    public SheetHeader setExtpend(Map<String, Object> extend) {
        this.expend = extend;
        return this;
    }

    public String getTitle() {
        return title;
    }

    public SheetHeader setTitle(String title) {
        this.title = title;
        return this;
    }

    public String getField() {
        return field;
    }

    public SheetHeader setField(String field) {
        this.field = field;
        return this;
    }

    public int getWidth() {
        return width;
    }

    public SheetHeader setWidth(int width) {
        this.width = width;
        return this;
    }

    public CellTypeEnum getCellType() {
        return cellType;
    }

    public SheetHeader setCellType(CellTypeEnum cellType) {
        this.cellType = cellType;
        return this;
    }

}
