package com.bxm.component.office.excel.parse.impl;

import com.bxm.component.office.excel.format.config.CellTypeEnum;
import com.bxm.component.office.excel.format.impl.AbstractCellConverter;
import org.apache.poi.ss.usermodel.Cell;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DefinedDataCellFormat extends AbstractCellConverter {

    @Override
    public boolean isMatch(CellTypeEnum cellType) {
        return CellTypeEnum.DATE.equals(cellType);
    }

    @Override
    public void setValue() {

    }

    @Override
    public Object getValue() {
        Class<?> clasz = getValueClass();

        int cellType = getCellType();

        Date date = null;
        if (cellType == Cell.CELL_TYPE_STRING) {
            String value = getCell().getStringCellValue();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy.MM.dd");
            try {
                date = sdf.parse(value);
            } catch (ParseException e) {
                e.printStackTrace();
            }
        } else if (cellType == Cell.CELL_TYPE_NUMERIC) {
            date = getCell().getDateCellValue();
        }

        if (null != date) {
            if (java.sql.Date.class.equals(clasz)) {
                return new java.sql.Date(date.getTime());
            }
            if (Timestamp.class.equals(clasz)) {
                return new Timestamp(date.getTime());
            }
        }

        return date;
    }

    @Override
    public int getOrder() {
        return Integer.MAX_VALUE;
    }

}
