package com.bxm.component.office.excel.parse;

import com.bxm.component.office.excel.format.CellValueManage;
import com.bxm.component.office.excel.parse.setting.ParseSetting;

import java.io.File;
import java.io.InputStream;
import java.util.List;

/**
 * 功能说明：<br/>
 * Excel文件解析接口
 * <br/>
 * 开发时间：2016年4月22日<br/>
 */
public interface ExcelParser<T> {

    CellValueManage getCellValueManage();

    /**
     * 注入excel单元格值处理转换器管理类
     * @param cellValueManage 值处理转换器管理类
     */
    void setCellValueManage(CellValueManage cellValueManage);

    /**
     * 解析指定的Excel文件，将其解析为指定的数据格式
     * @param excelFile 待解析文件
     * @param setting   设置参数
     * @return 解析结果，如果excel不存在数据则返回空数组
     */
    List<T> parse(File excelFile, ParseSetting setting);

    /**
     * 从请求流中获取excel并进行解析
     * @param inputStream excel文件流
     * @param setting     解析参数
     * @return 解析结果
     */
    List<T> parse(InputStream inputStream, ParseSetting setting);

}
