package com.bxm.component.office.excel.format.impl;

import com.bxm.component.office.excel.format.config.CellTypeEnum;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;

/**
 * 功能说明：<br/>
 * 文本型内容转换器
 * <br/>
 * 开发人员：liuj(liujia1@strongit.com.cn)<br/>
 * 开发时间：2016年3月3日<br/>
 */
public class TextCellConverter extends AbstractCellConverter {

    @Override
    public boolean isMatch(CellTypeEnum cellType) {
        return CellTypeEnum.TEXT.equals(cellType);
    }

    @Override
    public void setValue() {
        Object value = getSetValue();

        if (value == null) {
            value = "";
        }

        CellStyle cellStyle = getCell().getCellStyle();
        cellStyle.setAlignment(HorizontalAlignment.LEFT);

        getCell().setCellValue(value.toString());
    }

    @Override
    public int getOrder() {
        return 0;
    }

    @Override
    public Object getValue() {
        CellType cellType = getCellType();

        if (CellType.STRING == cellType) {
            return getCell().getStringCellValue();
        } else if (CellType.NUMERIC == cellType) {
            return getDoubleCellStringValue();
        }

        return null;
    }

}
