package com.bxm.component.office.excel.format.impl;

import com.bxm.component.office.excel.format.config.CellTypeEnum;
import com.bxm.newidea.component.tools.DateUtils;
import org.apache.poi.ss.usermodel.CellType;

import java.sql.Timestamp;
import java.util.Date;

/**
 * 功能说明：<br/>
 * 日期类型转换器
 * <br/>
 * 开发人员：liuj(liujia1@strongit.com.cn)<br/>
 * 开发时间：2016年3月3日<br/>
 */
public class DateCellConverter extends AbstractCellConverter {

    @Override
    public int getOrder() {
        return 0;
    }

    @Override
    public boolean isMatch(CellTypeEnum cellType) {
        return CellTypeEnum.DATE.equals(cellType);
    }

    @Override
    public void setValue() {
        Object value = getSetValue();
        if (value instanceof Date) {
            getCell().setCellValue(DateUtils.formatDate((Date) value));
        }
    }

    @Override
    public Object getValue() {
        CellType cellType = getCellType();

        Date date = null;
        if (cellType == CellType.STRING) {
            String value = getCell().getStringCellValue();
            date = DateUtils.parse(value);
        } else if (cellType == CellType.NUMERIC) {
            date = getCell().getDateCellValue();
        }

        Class<?> clasz = getValueClass();

        if (null != date) {
            if (java.sql.Date.class.equals(clasz)) {
                return new java.sql.Date(date.getTime());
            }
            if (Timestamp.class.equals(clasz)) {
                return new Timestamp(date.getTime());
            }
        }

        return date;
    }

}
