/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.component.office.excel.export.impl;

import com.bxm.component.office.excel.export.impl.AbstractExcelExport;
import com.bxm.component.office.excel.export.setting.ExcelSheet;
import com.bxm.component.office.excel.export.setting.SheetHeader;
import com.bxm.newidea.component.vo.BaseBean;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.ibatis.ognl.Ognl;
import org.apache.ibatis.ognl.OgnlException;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class SimpleExcelExporter
extends AbstractExcelExport {
    @Override
    protected void execExport() {
        this.createSheet();
    }

    private void createSheet() {
        for (ExcelSheet sheet : this.setting.getSheets()) {
            this.newSheet(sheet);
            if (StringUtils.isNotBlank((String)sheet.getContentTitle())) {
                this.createTitle(sheet.getContentTitle(), sheet.getHeaders());
            }
            this.createHeader(sheet.getHeaders());
            this.createContent(sheet);
        }
    }

    private void createTitle(String title, List<SheetHeader> headers) {
        int endCol = headers.size();
        this.newRow();
        this.setCellContent(title, 1, endCol, this.getTitleCellStyle());
    }

    private void createContent(ExcelSheet sheet) {
        block7: {
            block6: {
                if (null == sheet.getDataCollection()) break block6;
                for (BaseBean baseBean : sheet.getDataCollection()) {
                    this.newRow();
                    for (SheetHeader header : sheet.getHeaders()) {
                        Object value = null;
                        try {
                            value = Ognl.getValue((String)header.getField(), (Object)baseBean);
                        }
                        catch (OgnlException e) {
                            this.LOGGER.error("\u627e\u4e0d\u5230" + header.getField() + "\u7684\u503c");
                        }
                        this.getContext().addExtend("EXPORT_HEADER", header);
                        this.setContentCellContent(value, header.getCellType());
                    }
                }
                break block7;
            }
            if (null == sheet.getDataMap()) break block7;
            for (Map<String, Object> map : sheet.getDataMap()) {
                this.newRow();
                for (SheetHeader header : sheet.getHeaders()) {
                    Object value = map.get(header.getField());
                    this.getContext().addExtend("EXPORT_HEADER", header);
                    this.setContentCellContent(value, header.getCellType());
                }
            }
        }
    }
}

