/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.component.oncejob.storage.memory;

import com.bxm.component.oncejob.bootstrap.JobHolder;
import com.bxm.component.oncejob.config.ComponentOnceJobConfigurationProperties;
import com.bxm.component.oncejob.converter.JobConverter;
import com.bxm.component.oncejob.job.JobPersistentObject;
import com.bxm.component.oncejob.job.OnceJobDefinition;
import com.bxm.component.oncejob.storage.RecentJobRepository;
import com.bxm.newidea.component.tools.StringUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryRecentJobRepositoryImpl
implements RecentJobRepository {
    private static final Logger log = LoggerFactory.getLogger(MemoryRecentJobRepositoryImpl.class);
    private final List<JobPersistentObject> tempJobList = Collections.synchronizedList(Lists.newArrayList());
    private ComponentOnceJobConfigurationProperties properties;

    public MemoryRecentJobRepositoryImpl(ComponentOnceJobConfigurationProperties properties) {
        this.properties = properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<JobPersistentObject> load(long lastFireTimeMills, int num) {
        ArrayList result = Lists.newArrayList();
        int fetchNum = num;
        List<JobPersistentObject> list = this.tempJobList;
        synchronized (list) {
            Iterator<JobPersistentObject> iterator = this.tempJobList.iterator();
            while (iterator.hasNext()) {
                JobPersistentObject persistentObject = iterator.next();
                if (fetchNum <= 0) break;
                if (persistentObject.getFireDate() > lastFireTimeMills + (long)this.properties.getFetchIntervalMills()) continue;
                result.add(persistentObject);
                iterator.remove();
                --fetchNum;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("\u5269\u4f59\u4efb\u52a1\u6570\u91cf\uff1a{}", (Object)this.tempJobList.size());
        }
        return result;
    }

    @Override
    public void pushAll(List<JobPersistentObject> jobs) {
        this.tempJobList.addAll(jobs);
    }

    @Override
    public String saveJob(OnceJobDefinition definition) {
        JobPersistentObject persistentObject = JobConverter.convert(definition);
        this.tempJobList.add(persistentObject);
        return persistentObject.getJobId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeJob(String jobId) {
        List<JobPersistentObject> list = this.tempJobList;
        synchronized (list) {
            Iterator<JobPersistentObject> iterator = this.tempJobList.iterator();
            while (iterator.hasNext()) {
                JobPersistentObject persistentObject = iterator.next();
                if (!StringUtils.equals((CharSequence)persistentObject.getJobId(), (CharSequence)jobId)) continue;
                iterator.remove();
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<JobPersistentObject> clearDirty() {
        List<JobPersistentObject> list = this.tempJobList;
        synchronized (list) {
            Iterator<JobPersistentObject> iterator = this.tempJobList.iterator();
            while (iterator.hasNext()) {
                JobPersistentObject persistentObject = iterator.next();
                if (persistentObject.getFireDate() >= System.currentTimeMillis()) continue;
                iterator.remove();
                if (log.isDebugEnabled()) {
                    log.debug("\u5904\u7406\u8fc7\u671f\u4efb\u52a1\uff1a{}-{}", (Object)persistentObject.getJobId(), (Object)persistentObject.getFireDate());
                }
                JobHolder.pushJob(persistentObject);
            }
        }
        return Lists.newArrayList();
    }
}

