/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.component.oncejob.storage.mysql;

import com.bxm.component.oncejob.converter.JobConverter;
import com.bxm.component.oncejob.enums.JobStatusEnum;
import com.bxm.component.oncejob.job.JobPersistentObject;
import com.bxm.component.oncejob.job.OnceJobDefinition;
import com.bxm.component.oncejob.storage.RecentJobRepository;
import com.bxm.component.oncejob.storage.mysql.MysqlLock;
import com.google.common.collect.Lists;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.JdbcTemplate;

public class MysqlRecentJobRepository
implements RecentJobRepository {
    private static final Logger log = LoggerFactory.getLogger(MysqlRecentJobRepository.class);
    private JdbcTemplate jdbcTemplate;
    private MysqlLock mysqlLock;
    private static String INSERT_RECENT_SQL = "insert into t_component_job_recent ( job_id,status,expect_execute_time,create_time ) values ( ?,?,?,?)";

    @Override
    public List<JobPersistentObject> load(long lastFireTimeMills, int num) {
        return null;
    }

    @Override
    public void pushAll(final List<JobPersistentObject> jobs) {
        this.jdbcTemplate.batchUpdate(INSERT_RECENT_SQL, new BatchPreparedStatementSetter(){

            public void setValues(PreparedStatement ps, int i) throws SQLException {
                JobPersistentObject persistentObject = (JobPersistentObject)jobs.get(i);
                MysqlRecentJobRepository.this.setPreparedStatement(persistentObject, ps);
            }

            public int getBatchSize() {
                return jobs.size();
            }
        });
    }

    private void setPreparedStatement(JobPersistentObject persistentObject, PreparedStatement ps) throws SQLException {
        int index = 1;
        ps.setString(index++, persistentObject.getJobId());
        ps.setInt(index++, JobStatusEnum.WAIT.getCode());
        ps.setDate(index++, new Date(persistentObject.getFireDate()));
        ps.setDate(index, new Date(System.currentTimeMillis()));
    }

    @Override
    public String saveJob(OnceJobDefinition definition) {
        JobPersistentObject persistentObject = JobConverter.convert(definition);
        this.jdbcTemplate.update(INSERT_RECENT_SQL, ps -> this.setPreparedStatement(persistentObject, ps));
        return persistentObject.getJobId();
    }

    @Override
    public boolean removeJob(String jobId) {
        return this.jdbcTemplate.update("delete from t_component_job_recent where job_id = '" + jobId + "'") > 0;
    }

    @Override
    public List<JobPersistentObject> clearDirty() {
        return Lists.newArrayList();
    }

    public MysqlRecentJobRepository(JdbcTemplate jdbcTemplate, MysqlLock mysqlLock) {
        this.jdbcTemplate = jdbcTemplate;
        this.mysqlLock = mysqlLock;
    }
}

