/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.component.oncejob.storage.mysql;

import com.bxm.component.oncejob.config.ComponentOnceJobConfigurationProperties;
import com.bxm.component.oncejob.enums.ActionEnum;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.IPUtil;
import java.util.Date;
import java.util.StringJoiner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;

public class MysqlLock {
    private static final Logger log = LoggerFactory.getLogger(MysqlLock.class);
    private JdbcTemplate jdbcTemplate;
    private ComponentOnceJobConfigurationProperties properties;

    public boolean lock(ActionEnum action, int timeoutMills) {
        try {
            this.saveActionLock(action, timeoutMills);
        }
        catch (Exception e) {
            try {
                return this.tryRelocked(action, timeoutMills);
            }
            catch (Exception ex) {
                log.error(ex.getMessage(), (Throwable)ex);
                return false;
            }
        }
        return true;
    }

    private boolean tryRelocked(ActionEnum action, int timeoutMills) {
        Date releaseTime = (Date)this.jdbcTemplate.query("select release_time from t_component_job_lock", t -> t.getDate("release_time"));
        if (!DateUtils.before((Date)releaseTime)) {
            if (log.isDebugEnabled()) {
                log.debug("{}\u5df2\u88ab\u5176\u4ed6\u5b9e\u4f8b\u52a0\u9501", (Object)action);
            }
            return false;
        }
        String deleteSql = String.format("delete from t_component_job_lock where action = '%s' and app = '%s'", new Object[]{action, this.properties.getAppName()});
        this.jdbcTemplate.execute(deleteSql);
        log.info("\u9501\u672a\u53ca\u65f6\u91ca\u653e\u6216\u8bbe\u7f6e\u7684\u64cd\u4f5c\u95f4\u9694\u5b58\u5728\u95ee\u9898\uff0caction:{},releaseTime:{}", (Object)action, (Object)DateUtils.formatDateTime((Date)releaseTime));
        try {
            this.saveActionLock(action, timeoutMills);
        }
        catch (Exception e) {
            log.error("\u4e8c\u6b21\u52a0\u9501\u5931\u8d25\uff0caction:{},app:{}", (Object)action, (Object)this.properties.getAppName());
            log.error(e.getMessage());
            return false;
        }
        return true;
    }

    private void saveActionLock(ActionEnum action, int timeoutMills) {
        String[] columnArray;
        StringJoiner columnJoiner = new StringJoiner(",", "(", ")");
        StringJoiner valueJoiner = new StringJoiner(",", "(", ")");
        for (String column : columnArray = new String[]{"app", "action", "lock_time", "release_time", "instance"}) {
            columnJoiner.add(column);
            valueJoiner.add("?");
        }
        String sql = "insert into t_component_job_lock " + columnJoiner.toString() + " values " + valueJoiner.toString();
        this.jdbcTemplate.update(sql, ps -> {
            int index = 1;
            ps.setString(index++, this.properties.getAppName());
            ps.setString(index++, action.name());
            ps.setDate(index++, new java.sql.Date(System.currentTimeMillis()));
            ps.setDate(index++, new java.sql.Date(System.currentTimeMillis() + (long)timeoutMills));
            ps.setString(index, IPUtil.getLocalRealIp());
        });
    }

    public boolean unlock(String action) {
        String deleteSql = String.format("delete from t_component_job_lock where action = '%s' and app = '%s' and instance = '%s'", action, this.properties.getAppName(), IPUtil.getLocalRealIp());
        int rows = this.jdbcTemplate.update(deleteSql);
        if (rows > 0) {
            return true;
        }
        log.info("\u89e3\u9501\u5931\u8d25\uff0caction\uff1a{},app:{},instance:{}", new Object[]{action, this.properties.getAppName(), IPUtil.getLocalRealIp()});
        return false;
    }

    public MysqlLock(JdbcTemplate jdbcTemplate, ComponentOnceJobConfigurationProperties properties) {
        this.jdbcTemplate = jdbcTemplate;
        this.properties = properties;
    }
}

