/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.component.oncejob.job;

import com.bxm.component.oncejob.enums.MissFireStrategy;
import com.bxm.component.oncejob.job.IOnceJobCallback;
import java.util.Date;

public class OnceJobDefinition<T> {
    private MissFireStrategy missFire;
    private T param;
    private Date fireDate;
    private IOnceJobCallback<T> callback;

    private OnceJobDefinition() {
    }

    public static OnceJobBuilder builder(Date fireDate) {
        OnceJobBuilder builder = new OnceJobBuilder();
        builder.fireDate(fireDate);
        return builder;
    }

    public static OnceJobBuilder builder() {
        return new OnceJobBuilder();
    }

    public MissFireStrategy getMissFire() {
        return this.missFire;
    }

    public T getParam() {
        return this.param;
    }

    public Date getFireDate() {
        return this.fireDate;
    }

    public IOnceJobCallback<T> getCallback() {
        return this.callback;
    }

    public String toString() {
        return "OnceJobDefinition(missFire=" + (Object)((Object)this.getMissFire()) + ", param=" + this.getParam() + ", fireDate=" + this.getFireDate() + ", callback=" + this.getCallback() + ")";
    }

    public static class OnceJobBuilder {
        private MissFireStrategy missFire = MissFireStrategy.REMAIN;
        private Date fireDate;

        private OnceJobBuilder() {
        }

        public OnceJobBuilder missFire(MissFireStrategy missFire) {
            this.missFire = missFire;
            return this;
        }

        public OnceJobBuilder fireDate(Date fireDate) {
            this.fireDate = fireDate;
            return this;
        }

        public <T> OnceJobDefinition<T> build(IOnceJobCallback<T> callback, T param) {
            OnceJobDefinition onceJobDefinition = new OnceJobDefinition();
            onceJobDefinition.missFire = this.missFire;
            onceJobDefinition.fireDate = this.fireDate;
            onceJobDefinition.callback = callback;
            onceJobDefinition.param = param;
            return onceJobDefinition;
        }

        public <T> OnceJobDefinition<T> build(IOnceJobCallback<T> callback) {
            return this.build(callback, null);
        }
    }
}

