package com.bxm.component.oncejob.storage;

import com.bxm.component.oncejob.job.JobPersistentObject;

import java.util.List;

/**
 * 短期内的一次性任务处理，用于处理即将执行的任务，具体的判断界限见配置
 *
 * @author liujia
 * @date 7/30/21 10:18 AM
 **/
public interface RecentJobRepository extends JobRepository {

    /**
     * 加载指定时间到当前时间的未处理任务
     *
     * @param lastFireTimeMills 触发事件，不能小于当前时间
     * @param num               拉取的数量
     * @return 序列化的任务信息
     */
    List<JobPersistentObject> load(long lastFireTimeMills, int num);

    /**
     * 批量增加调度任务
     *
     * @param jobs 待保存的任务列表
     */
    void pushAll(List<JobPersistentObject> jobs);
}
