package com.bxm.component.oncejob.storage.mysql;

import com.bxm.component.oncejob.converter.JobConverter;
import com.bxm.component.oncejob.enums.JobStatusEnum;
import com.bxm.component.oncejob.job.JobPersistentObject;
import com.bxm.component.oncejob.job.OnceJobDefinition;
import com.bxm.component.oncejob.storage.RecentJobRepository;
import com.google.common.collect.Lists;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.JdbcTemplate;

import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;

/**
 * 基于MySQL实现的短期任务处理
 *
 * @author liujia
 * @date 8/2/21 8:41 PM
 **/
@Slf4j
@AllArgsConstructor
public class MysqlRecentJobRepository implements RecentJobRepository {

    private JdbcTemplate jdbcTemplate;

    private MysqlLock mysqlLock;

    private static String INSERT_RECENT_SQL = "insert into t_component_job_recent ( " +
            "job_id," +
            "status," +
            "expect_execute_time," +
            "create_time " +
            ") values ( " +
            "?," +
            "?," +
            "?," +
            "?)";

    @Override
    public List<JobPersistentObject> load(long lastFireTimeMills, int num) {
        return null;
    }

    @Override
    public void pushAll(List<JobPersistentObject> jobs) {
        jdbcTemplate.batchUpdate(INSERT_RECENT_SQL, new BatchPreparedStatementSetter() {

            @Override
            public void setValues(PreparedStatement ps, int i) throws SQLException {
                JobPersistentObject persistentObject = jobs.get(i);
                setPreparedStatement(persistentObject, ps);
            }

            @Override
            public int getBatchSize() {
                return jobs.size();
            }
        });
    }

    private void setPreparedStatement(JobPersistentObject persistentObject, PreparedStatement ps) throws SQLException {
        int index = 1;
        ps.setString(index++, persistentObject.getJobId());
        ps.setInt(index++, JobStatusEnum.WAIT.getCode());
        ps.setDate(index++, new Date(persistentObject.getFireDate()));
        ps.setDate(index, new Date(System.currentTimeMillis()));
    }

    @Override
    public String saveJob(OnceJobDefinition definition) {
        JobPersistentObject persistentObject = JobConverter.convert(definition);

        jdbcTemplate.update(INSERT_RECENT_SQL, ps -> setPreparedStatement(persistentObject, ps));

        return persistentObject.getJobId();
    }

    @Override
    public boolean removeJob(String jobId) {
        return jdbcTemplate.update("delete from t_component_job_recent where job_id = '" + jobId + "'") > 0;
    }

    @Override
    public List<JobPersistentObject> clearDirty() {
        return Lists.newArrayList();
    }
}
