package com.bxm.component.oncejob.utils;

import cn.hutool.core.util.NumberUtil;
import com.bxm.component.oncejob.job.JobPersistentObject;
import com.google.common.base.Splitter;
import lombok.experimental.UtilityClass;

/**
 * 任务ID处理工具
 * 创建一个可以解析的任务ID
 *
 * @author liujia
 * @date 8/12/21 1:47 PM
 **/
@UtilityClass
public class JobIdUtil {

    private static String JOINER = "_";

    public static String buildJobId(JobPersistentObject persistentObject) {
        return persistentObject.getFireDate() + JOINER + Integer.toHexString(persistentObject.hashCode());
    }

    public static long getFireMills(String jobId) {
        String fireMillsStr = Splitter.on(JOINER).split(jobId).iterator().next();

        return NumberUtil.parseLong(fireMillsStr);
    }
}
