/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.payment.service.impl;

import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayClient;
import com.alipay.api.AlipayObject;
import com.alipay.api.AlipayRequest;
import com.alipay.api.domain.AlipayTradeRefundModel;
import com.alipay.api.request.AlipayTradeRefundRequest;
import com.alipay.api.response.AlipayTradeRefundResponse;
import com.bxm.newidea.component.payment.enums.PaymentActionEnum;
import com.bxm.newidea.component.payment.enums.PaymentPlatformEnum;
import com.bxm.newidea.component.payment.request.AlipayRefundRequest;
import com.bxm.newidea.component.payment.response.AlipayRefundResponse;
import com.bxm.newidea.component.payment.service.IPaymentAction;
import com.bxm.newidea.component.payment.service.impl.BasePaymentAction;
import com.bxm.newidea.component.tools.NumberUtils;
import com.bxm.newidea.component.tools.StringUtils;
import java.math.RoundingMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AlipayRefundAction
extends BasePaymentAction
implements IPaymentAction<AlipayRefundRequest, AlipayRefundResponse> {
    private static final Logger log = LoggerFactory.getLogger(AlipayRefundAction.class);

    @Override
    public AlipayRefundResponse exec(AlipayRefundRequest request) {
        AlipayClient alipayClient;
        if (log.isDebugEnabled()) {
            log.debug("\u7533\u8bf7\u652f\u4ed8\u5b9d\u9000\u6b3e\u53c2\u6570\uff1a{}", (Object)request);
        }
        if ((alipayClient = this.configContext.obtainAlipayClient(request.getScene())) == null) {
            return null;
        }
        AlipayTradeRefundModel model = new AlipayTradeRefundModel();
        model.setTradeNo(request.getTradeNo());
        model.setOutRequestNo(request.getOutRefundNo());
        model.setRefundAmount(NumberUtils.format((double)request.getAmount().setScale(2, RoundingMode.HALF_DOWN).floatValue()));
        model.setRefundReason(request.getRefundReason());
        AlipayTradeRefundRequest tradeRefundRequest = new AlipayTradeRefundRequest();
        tradeRefundRequest.setBizModel((AlipayObject)model);
        try {
            AlipayTradeRefundResponse response = (AlipayTradeRefundResponse)alipayClient.execute((AlipayRequest)tradeRefundRequest);
            AlipayRefundResponse refundResponse = new AlipayRefundResponse();
            refundResponse.setResponse(response);
            refundResponse.setRefundResult(StringUtils.equals((CharSequence)response.getCode(), (CharSequence)"10000"));
            return refundResponse;
        }
        catch (AlipayApiException e) {
            log.error("\u652f\u4ed8\u5b9d\u7533\u8bf7\u9000\u6b3e\u5931\u8d25\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)request);
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public PaymentPlatformEnum matchPlatform() {
        return PaymentPlatformEnum.ALIPAY;
    }

    @Override
    public PaymentActionEnum matchAction() {
        return PaymentActionEnum.REFUND;
    }
}

