/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.payment.config;

import com.alipay.api.AlipayClient;
import com.alipay.api.DefaultAlipayClient;
import com.bxm.component.httpclient.utils.OkHttpUtils;
import com.bxm.newidea.component.payment.config.AlipayMchAccount;
import com.bxm.newidea.component.payment.config.PaymentProperties;
import com.bxm.newidea.component.payment.config.WechatMchAccount;
import com.github.binarywang.wxpay.config.WxPayConfig;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.github.binarywang.wxpay.service.WxPayService;
import com.github.binarywang.wxpay.service.impl.WxPayServiceImpl;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaymentMchConfigContext {
    private static final Logger log = LoggerFactory.getLogger(PaymentMchConfigContext.class);
    private final PaymentProperties properties;
    private Map<String, AlipayClient> alipayClientMap = Maps.newHashMap();
    private Map<String, WxPayService> wxPayServiceMap = Maps.newHashMap();

    PaymentMchConfigContext(PaymentProperties properties) {
        this.properties = properties;
        this.refresh(false);
    }

    public AlipayClient obtainAlipayClient(String scene) {
        AlipayClient alipayClient = this.alipayClientMap.get(scene);
        if (null == alipayClient) {
            log.error("\u8bf7\u6c42\u7684\u573a\u666f[{}]\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u652f\u4ed8\u5b9d\u5546\u6237\u53f7", (Object)scene);
        }
        return alipayClient;
    }

    public AlipayMchAccount obtainAlipayAccount(String appId) {
        for (Map.Entry<String, AlipayMchAccount> entry : this.properties.getAlipayMchAccounts().entrySet()) {
            if (!StringUtils.equals((CharSequence)appId, (CharSequence)entry.getValue().getAppId())) continue;
            return entry.getValue();
        }
        return null;
    }

    public WxPayService obtainWxPayService(String scene) {
        WxPayService wxPayService = this.wxPayServiceMap.get(scene);
        if (null == wxPayService) {
            log.error("\u8bf7\u6c42\u7684\u573a\u666f[{}]\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u5fae\u4fe1\u5546\u6237\u53f7", (Object)scene);
        } else {
            log.debug("\u8bf7\u6c42\u7684\u573a\u666f[{}]\u5bf9\u5e94\u7684\u5fae\u4fe1\u5546\u6237\u53f7\u4e3a[{}]", (Object)scene, (Object)wxPayService.getConfig().getMchId());
        }
        return wxPayService;
    }

    public WxPayService obtainWxPayServiceByMchId(String mchId) {
        for (Map.Entry<String, WxPayService> entry : this.wxPayServiceMap.entrySet()) {
            if (!StringUtils.equals((CharSequence)mchId, (CharSequence)entry.getValue().getConfig().getMchId())) continue;
            return entry.getValue();
        }
        log.warn("\u4e0d\u5b58\u5728\u5546\u6237ID[{}]\u5bf9\u5e94\u7684\u670d\u52a1\u5b9e\u4f8b", (Object)mchId);
        return null;
    }

    public void refresh(boolean reloadKeypairFile) {
        HashMap swapWxpayServiceMap = Maps.newHashMap();
        HashMap swapAlipayClientMap = Maps.newHashMap();
        for (Map.Entry<String, WechatMchAccount> entry : this.properties.getWechatMchAccounts().entrySet()) {
            swapWxpayServiceMap.put(entry.getKey(), this.build(entry.getValue(), reloadKeypairFile));
        }
        for (Map.Entry<String, Object> entry : this.properties.getAlipayMchAccounts().entrySet()) {
            AlipayClient alipayClient = this.build((AlipayMchAccount)entry.getValue());
            swapAlipayClientMap.put(entry.getKey(), alipayClient);
        }
        this.wxPayServiceMap = swapWxpayServiceMap;
        this.alipayClientMap = swapAlipayClientMap;
    }

    private WxPayService build(WechatMchAccount account, boolean reloadKeypairFile) {
        WxPayConfig payConfig = new WxPayConfig();
        payConfig.setMchId(account.getMchId());
        payConfig.setMchKey(account.getMchKey());
        payConfig.setKeyPath(this.get(account, reloadKeypairFile));
        payConfig.setNotifyUrl(account.getNotifyUrl());
        payConfig.setUseSandboxEnv(account.getSandbox().booleanValue());
        WxPayServiceImpl wxPayService = new WxPayServiceImpl();
        wxPayService.setConfig(payConfig);
        if (Boolean.TRUE.equals(account.getSandbox())) {
            try {
                payConfig.setMchKey(wxPayService.getSandboxSignKey());
            }
            catch (WxPayException e) {
                log.error("\u6c99\u7bb1\u73af\u5883\u5f00\u542f\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
            }
        }
        return wxPayService;
    }

    private String get(WechatMchAccount account, boolean override) {
        if (!StringUtils.startsWith((CharSequence)account.getKeyPath(), (CharSequence)"http")) {
            return account.getKeyPath();
        }
        File keyPairFileRoot = new File(this.properties.getKeypairPath());
        if (keyPairFileRoot.isFile()) {
            keyPairFileRoot = keyPairFileRoot.getParentFile();
        }
        if (!keyPairFileRoot.canWrite()) {
            log.warn("\u914d\u7f6e\u7684\u5bc6\u94a5\u6587\u4ef6\u5b58\u653e\u5730\u5740[{}]\u65e0\u8bfb\u53d6\u6743\u9650\uff0c\u4fee\u6539\u5b58\u653e\u5730\u5740\u4e3a\u4e34\u65f6\u76ee\u5f55", (Object)this.properties.getKeypairPath());
            keyPairFileRoot = new File(System.getProperty("user.dir"));
        }
        String finalFilePath = keyPairFileRoot.getAbsolutePath() + account.getMchId() + ".wst";
        File keyPairFile = new File(finalFilePath);
        if (override || !keyPairFile.exists()) {
            OkHttpUtils.download((String)account.getKeyPath(), (String)finalFilePath);
        }
        if (!keyPairFile.exists()) {
            log.error("\u5bc6\u94a5\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff0c\u5bc6\u94a5\u6587\u4ef6\u5730\u5740\u4e3a\uff1a{}", (Object)account.getKeyPath());
        }
        return finalFilePath;
    }

    private AlipayClient build(AlipayMchAccount account) {
        return new DefaultAlipayClient(account.getGateWayUrl(), account.getAppId(), account.getPrivateKey(), account.getFormat(), account.getCharset(), account.getPublicKey(), account.getSignType());
    }
}

