/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.payment.service.impl;

import com.bxm.newidea.component.payment.enums.PaymentActionEnum;
import com.bxm.newidea.component.payment.enums.PaymentModeEnum;
import com.bxm.newidea.component.payment.enums.PaymentPlatformEnum;
import com.bxm.newidea.component.payment.request.WechatAppPreOrderRequest;
import com.bxm.newidea.component.payment.response.WechatAppPreOrderResponse;
import com.bxm.newidea.component.payment.service.IPaymentAction;
import com.bxm.newidea.component.payment.service.impl.BasePaymentAction;
import com.github.binarywang.wxpay.bean.order.WxPayAppOrderResult;
import com.github.binarywang.wxpay.bean.request.BaseWxPayRequest;
import com.github.binarywang.wxpay.bean.request.WxPayUnifiedOrderRequest;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.github.binarywang.wxpay.service.WxPayService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class WechatAppPreOrderAction
extends BasePaymentAction
implements IPaymentAction<WechatAppPreOrderRequest, WechatAppPreOrderResponse> {
    private static final Logger log = LoggerFactory.getLogger(WechatAppPreOrderAction.class);

    @Override
    public WechatAppPreOrderResponse exec(WechatAppPreOrderRequest request) {
        WxPayService wxPayService = this.configContext.obtainWxPayService(request.getScene());
        if (wxPayService == null) {
            return null;
        }
        WxPayUnifiedOrderRequest wxPayUnifiedOrderRequest = new WxPayUnifiedOrderRequest();
        wxPayUnifiedOrderRequest.setDeviceInfo("APP");
        wxPayUnifiedOrderRequest.setOutTradeNo(request.getOrderNum());
        wxPayUnifiedOrderRequest.setBody(request.getOrderDescription());
        wxPayUnifiedOrderRequest.setTotalFee(BaseWxPayRequest.yuanToFen((String)request.getAmount().toString()));
        wxPayUnifiedOrderRequest.setSpbillCreateIp(request.getRequestIp());
        wxPayUnifiedOrderRequest.setTradeType("APP");
        try {
            WxPayAppOrderResult result = (WxPayAppOrderResult)wxPayService.createOrder(wxPayUnifiedOrderRequest);
            WechatAppPreOrderResponse response = new WechatAppPreOrderResponse();
            response.setAppId(result.getAppId());
            response.setNonceStr(result.getNonceStr());
            response.setPackageValue(result.getPackageValue());
            response.setPartnerId(result.getPartnerId());
            response.setPrepayId(result.getPrepayId());
            response.setTimeStamp(result.getTimeStamp());
            response.setSign(result.getSign());
            return response;
        }
        catch (WxPayException e) {
            log.error("\u521b\u5efaH5\u9884\u652f\u4ed8\u8ba2\u5355\u5931\u8d25\uff0c\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a{}", (Object)request);
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public PaymentPlatformEnum matchPlatform() {
        return PaymentPlatformEnum.WECHAT;
    }

    @Override
    public PaymentModeEnum matchMode() {
        return PaymentModeEnum.APP;
    }

    @Override
    public PaymentActionEnum matchAction() {
        return PaymentActionEnum.PRE_PAYMENT;
    }
}

