/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.payment.service.impl;

import com.bxm.newidea.component.payment.enums.PaymentActionEnum;
import com.bxm.newidea.component.payment.enums.PaymentPlatformEnum;
import com.bxm.newidea.component.payment.request.WechatPaymentCallbackRequest;
import com.bxm.newidea.component.payment.response.WechatPaymentCallbackResponse;
import com.bxm.newidea.component.payment.service.IPaymentAction;
import com.bxm.newidea.component.payment.service.impl.BasePaymentAction;
import com.github.binarywang.wxpay.bean.notify.WxPayOrderNotifyResult;
import com.github.binarywang.wxpay.service.WxPayService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class WechatPaymentCallbackAction
extends BasePaymentAction
implements IPaymentAction<WechatPaymentCallbackRequest, WechatPaymentCallbackResponse> {
    private static final Logger log = LoggerFactory.getLogger(WechatPaymentCallbackAction.class);

    @Override
    public WechatPaymentCallbackResponse exec(WechatPaymentCallbackRequest request) {
        if (log.isDebugEnabled()) {
            log.debug("\u5fae\u4fe1\u652f\u4ed8\u7ed3\u679c\u56de\u8c03\uff0c\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a{}", (Object)request);
        }
        try {
            String mchId;
            WxPayService wxPayService;
            WxPayOrderNotifyResult preParseResult = WxPayOrderNotifyResult.fromXML((String)request.getCallbackData());
            if ("SUCCESS".equals(preParseResult.getReturnCode()) && "SUCCESS".equals(preParseResult.getResultCode()) && null != (wxPayService = this.configContext.obtainWxPayServiceByMchId(mchId = preParseResult.getMchId()))) {
                WxPayOrderNotifyResult result = wxPayService.parseOrderNotifyResult(request.getCallbackData());
                WechatPaymentCallbackResponse response = new WechatPaymentCallbackResponse();
                response.setResult(result);
                response.setSuccess(Boolean.TRUE);
                return response;
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            log.error("\u652f\u4ed8\u7ed3\u679c\u65e0\u6cd5\u89e3\u6790\u4e3a\u5bf9\u5e94\u7684\u683c\u5f0f,\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a{}", (Object)request);
        }
        return null;
    }

    @Override
    public PaymentPlatformEnum matchPlatform() {
        return PaymentPlatformEnum.WECHAT;
    }

    @Override
    public PaymentActionEnum matchAction() {
        return PaymentActionEnum.PAYMENT_CALLBACK;
    }
}

