/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.payment.service.impl;

import com.bxm.newidea.component.payment.enums.PaymentActionEnum;
import com.bxm.newidea.component.payment.enums.PaymentPlatformEnum;
import com.bxm.newidea.component.payment.request.WechatTransfersRequest;
import com.bxm.newidea.component.payment.request.WxPayWithdrawRequest;
import com.bxm.newidea.component.payment.response.WechatTransfersResponse;
import com.bxm.newidea.component.payment.response.WxWithdrawResult;
import com.bxm.newidea.component.payment.service.IPaymentAction;
import com.bxm.newidea.component.payment.service.impl.BasePaymentAction;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.wechat.config.WechatMpContext;
import com.github.binarywang.wxpay.bean.request.BaseWxPayRequest;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.github.binarywang.wxpay.service.WxPayService;
import com.thoughtworks.xstream.XStream;
import me.chanjar.weixin.mp.api.WxMpService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WechatTransfersAction
extends BasePaymentAction
implements IPaymentAction<WechatTransfersRequest, WechatTransfersResponse> {
    private static final Logger log = LoggerFactory.getLogger(WechatTransfersAction.class);
    @Autowired
    private WechatMpContext wechatMpContext;

    @Override
    public WechatTransfersResponse exec(WechatTransfersRequest request) {
        WxPayService wxPayService = this.configContext.obtainWxPayService(request.getScene());
        if (wxPayService == null) {
            return null;
        }
        WxPayWithdrawRequest wxPayWithdrawRequest = this.generateWithdraw(request);
        try {
            wxPayWithdrawRequest.checkAndSign(wxPayService.getConfig());
            String url = wxPayService.getPayBaseUrl() + "/mmpaymkttransfers/promotion/transfers";
            String responseContent = wxPayService.post(url, wxPayWithdrawRequest.toXML(), Boolean.TRUE.booleanValue());
            XStream xstream = new XStream();
            XStream.setupDefaultSecurity((XStream)xstream);
            xstream.processAnnotations(WxWithdrawResult.class);
            xstream.allowTypes(new Class[]{WxWithdrawResult.class});
            WxWithdrawResult result = (WxWithdrawResult)((Object)xstream.fromXML(responseContent));
            WechatTransfersResponse response = new WechatTransfersResponse();
            response.setResult(result);
            response.setSuccess(StringUtils.equals((CharSequence)"SUCCESS", (CharSequence)result.getResultCode()) && StringUtils.equals((CharSequence)"SUCCESS", (CharSequence)result.getReturnCode()));
            return response;
        }
        catch (WxPayException e) {
            log.error(e.getMessage(), (Throwable)e);
            log.error("\u53d1\u8d77\u63d0\u73b0\u5931\u8d25\uff0c\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a{}", (Object)request);
            return null;
        }
    }

    private WxPayWithdrawRequest generateWithdraw(WechatTransfersRequest request) {
        WxMpService wxMpService = this.wechatMpContext.obtain(request.getScene());
        String appId = wxMpService.getWxMpConfigStorage().getAppId();
        WxPayWithdrawRequest wxPayWithdrawRequest = new WxPayWithdrawRequest();
        wxPayWithdrawRequest.setAppid(appId);
        wxPayWithdrawRequest.setOpenId(request.getWechatOpenId());
        wxPayWithdrawRequest.setAmount(BaseWxPayRequest.yuanToFen((String)request.getAmount().toString()));
        wxPayWithdrawRequest.setCheckName("NO_CHECK");
        wxPayWithdrawRequest.setDesc(request.getDescription());
        wxPayWithdrawRequest.setPartnerTradeNo(request.getOrderNo());
        wxPayWithdrawRequest.setSpbillCreateIp(request.getReqeusetIp());
        return wxPayWithdrawRequest;
    }

    @Override
    public PaymentPlatformEnum matchPlatform() {
        return PaymentPlatformEnum.ALIPAY;
    }

    @Override
    public PaymentActionEnum matchAction() {
        return PaymentActionEnum.TRANSFERS;
    }
}

