package com.bxm.newidea.component.payment.response;

import com.github.binarywang.wxpay.bean.result.BaseWxPayResult;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import org.w3c.dom.Document;

/**
 * @author zhaoyadong 2019/3/11 20:52
 * @desc
 */
@Data
@EqualsAndHashCode(callSuper = true)
@NoArgsConstructor
@XStreamAlias("xml")
public class WxWithdrawResult extends BaseWxPayResult {

    /**
     * 商户账号appid
     */
    @XStreamAlias("mch_appid")
    private String mchAppid;

    @XStreamAlias("mchid")
    private String mchId;

    /**
     * 设备信息
     * 微信支付分配的终端设备号
     */
    @XStreamAlias("device_info")
    private String deviceInfo;

    /**
     * 商户订单号
     * 商户订单号，需保持唯一性
     * (只能是字母或者数字，不能包含有其他字符)
     */
    @XStreamAlias("partner_trade_no")
    private String partnerTradeNo;

    /**
     * 微信付款单号
     * 企业付款成功，返回的微信付款单号
     */
    @XStreamAlias("payment_no")
    private String paymentNo;

    /**
     * 付款成功时间
     * 企业付款成功时间
     */
    @XStreamAlias("payment_time")
    private String paymentTime;

    @Override
    protected void loadXML(Document d) {

    }
}
