package com.bxm.newidea.component.payment.enums;

/**
 * 支付动作枚举,对应着不同的支付环节，不同的支付平台和支付模式之间会有区别
 *
 * @author liujia
 */
public enum PaymentActionEnum {

    /**
     * 在支付之前发起预付款订单
     */
    PRE_PAYMENT,

    /**
     * 执行支付回调处理
     */
    PAYMENT_CALLBACK,

    /**
     * 转账到用户
     */
    TRANSFERS,

    /**
     * 发起退款，从商户号原路退回
     */
    REFUND,

    /**
     * 退款处理结果回调
     */
    REFUND_CALLBACK,

    /**
     * 支付结果查询
     */
    QUERY,
}
