package com.bxm.newidea.component.payment.request;

import com.bxm.newidea.component.payment.enums.PaymentActionEnum;
import com.bxm.newidea.component.payment.enums.PaymentModeEnum;
import com.bxm.newidea.component.payment.enums.PaymentPlatformEnum;
import com.bxm.newidea.component.payment.response.PaymentResponse;
import lombok.Data;
import lombok.ToString;
import lombok.extern.slf4j.Slf4j;

/**
 * 支付动作发起参数
 *
 * @param <T> 支付请求对应的支付响应类，无实际用途，主要表明对应关系
 * @author liujia
 */
@Data
@Slf4j
@ToString
public class PaymentRequest<T extends PaymentResponse> {
    /**
     * 支付场景，用于查找该支付场景下对应的账号配置信息
     * 除支付回调这种无法确定场景的情况，其他场景均需要
     */
    private String scene;

    /**
     * 支付动作，根据具体的
     */
    private PaymentActionEnum action;

    /**
     * 支付平台
     */
    private PaymentPlatformEnum platform;

    /**
     * 支付模式,不做强制要求，不是所有的支付动作都需要此值
     */
    private PaymentModeEnum mode = PaymentModeEnum.COMMON;

    /**
     * 验证参数是否完整
     *
     * @return false表示验证失败
     */
    public boolean verify() {
        boolean res = true;

        if (null == action) {
            log.error("具体的支付动作必须指定");
            res = false;
        }

        if (null == platform) {
            log.error("支付平台必须指定");
        }

        if (null == mode) {
            log.error("支付模式不能为空");
        }

        return res;
    }
}
