package com.bxm.newidea.component.payment.service.impl;

import com.bxm.newidea.component.payment.enums.PaymentActionEnum;
import com.bxm.newidea.component.payment.enums.PaymentModeEnum;
import com.bxm.newidea.component.payment.enums.PaymentPlatformEnum;
import com.bxm.newidea.component.payment.request.WechatAppPreOrderRequest;
import com.bxm.newidea.component.payment.response.WechatAppPreOrderResponse;
import com.bxm.newidea.component.payment.service.IPaymentAction;
import com.github.binarywang.wxpay.bean.order.WxPayAppOrderResult;
import com.github.binarywang.wxpay.bean.request.BaseWxPayRequest;
import com.github.binarywang.wxpay.bean.request.WxPayUnifiedOrderRequest;
import com.github.binarywang.wxpay.constant.WxPayConstants;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.github.binarywang.wxpay.service.WxPayService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * 微信发起APP预支付订单
 *
 * @author liujia
 */
@Component
@Slf4j
public class WechatAppPreOrderAction extends BasePaymentAction implements IPaymentAction<WechatAppPreOrderRequest, WechatAppPreOrderResponse> {

    @SuppressWarnings("Duplicates")
    @Override
    public WechatAppPreOrderResponse exec(WechatAppPreOrderRequest request) {
        WxPayService wxPayService = configContext.obtainWxPayService(request.getScene());

        if (wxPayService == null) {
            return null;
        }

        WxPayUnifiedOrderRequest wxPayUnifiedOrderRequest = new WxPayUnifiedOrderRequest();

        wxPayUnifiedOrderRequest.setDeviceInfo("APP");
        wxPayUnifiedOrderRequest.setOutTradeNo(request.getOrderNum());
        wxPayUnifiedOrderRequest.setBody(request.getOrderDescription());
        wxPayUnifiedOrderRequest.setTotalFee(BaseWxPayRequest.yuanToFen(request.getAmount().toString()));
        wxPayUnifiedOrderRequest.setSpbillCreateIp(request.getRequestIp());
        wxPayUnifiedOrderRequest.setTradeType(WxPayConstants.TradeType.APP);

        try {
            WxPayAppOrderResult result = wxPayService.createOrder(wxPayUnifiedOrderRequest);

            WechatAppPreOrderResponse response = new WechatAppPreOrderResponse();
            response.setAppId(result.getAppId());
            response.setNonceStr(result.getNonceStr());
            response.setPackageValue(result.getPackageValue());
            response.setPartnerId(result.getPartnerId());
            response.setPrepayId(result.getPrepayId());
            response.setTimeStamp(result.getTimeStamp());
            response.setSign(result.getSign());
            return response;
        } catch (WxPayException e) {
            log.error("创建H5预支付订单失败，请求参数为：{}", request);
            log.error(e.getMessage(), e);
            return null;
        }
    }

    @Override
    public PaymentPlatformEnum matchPlatform() {
        return PaymentPlatformEnum.WECHAT;
    }

    @Override
    public PaymentModeEnum matchMode() {
        return PaymentModeEnum.APP;
    }

    @Override
    public PaymentActionEnum matchAction() {
        return PaymentActionEnum.PRE_PAYMENT;
    }
}
