/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.tools;

import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.HanyuPinyinVCharType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PinyinUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(PinyinUtils.class);

    private PinyinUtils() {
    }

    public static String getPinYin(String src) {
        char[] t1 = src.toCharArray();
        HanyuPinyinOutputFormat t3 = new HanyuPinyinOutputFormat();
        t3.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        t3.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        t3.setVCharType(HanyuPinyinVCharType.WITH_V);
        StringBuilder t4 = new StringBuilder();
        int t0 = t1.length;
        try {
            for (char aT1 : t1) {
                if (Character.toString(aT1).matches("[\\u4E00-\\u9FA5]+")) {
                    String[] t2 = PinyinHelper.toHanyuPinyinStringArray((char)aT1, (HanyuPinyinOutputFormat)t3);
                    t4.append(t2[0]);
                    continue;
                }
                t4.append(Character.toString(aT1));
            }
        }
        catch (BadHanyuPinyinOutputFormatCombination e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return t4.toString();
    }

    public static String[] getPinyinArray(String src) {
        char[] t1 = src.toCharArray();
        String[] res = new String[t1.length];
        HanyuPinyinOutputFormat t3 = new HanyuPinyinOutputFormat();
        t3.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        t3.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        t3.setVCharType(HanyuPinyinVCharType.WITH_V);
        try {
            int index = 0;
            for (char aT1 : t1) {
                if (Character.toString(aT1).matches("[\\u4E00-\\u9FA5]+")) {
                    String[] t2 = PinyinHelper.toHanyuPinyinStringArray((char)aT1, (HanyuPinyinOutputFormat)t3);
                    res[index++] = t2[0];
                    continue;
                }
                res[index++] = Character.toString(aT1);
            }
        }
        catch (BadHanyuPinyinOutputFormatCombination e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return res;
    }

    public static String getPinYinHeadChar(String str) {
        StringBuilder convert = new StringBuilder();
        for (int j = 0; j < str.length(); ++j) {
            char word = str.charAt(j);
            String[] pinyinArray = PinyinHelper.toHanyuPinyinStringArray((char)word);
            if (pinyinArray != null) {
                convert.append(pinyinArray[0].charAt(0));
                continue;
            }
            convert.append(word);
        }
        return convert.toString();
    }

    public static String getCnASCII(String cnStr) {
        byte[] bGBK;
        StringBuilder strBuf = new StringBuilder();
        for (byte aBGBK : bGBK = cnStr.getBytes()) {
            strBuf.append(Integer.toHexString(aBGBK & 0xFF)).append(" ");
        }
        return strBuf.toString();
    }
}

