package com.bxm.component.poster.utils;

import com.bxm.component.poster.template.extend.FontStyle;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;

import java.awt.*;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;

/**
 * @author liujia
 * @date 12/17/20 8:19 PM
 **/
@Slf4j
public class FontManage {
    private FontManage() {
    }


    private static Map<String, Font> fontMap = Maps.newHashMap();

    public static String DEFAULT_FONT = "default";

    public static void init() {
        FontStyle fontStyle = new FontStyle();
        fontStyle.setName("default");
        fontStyle.setUrl("https://mtest.wstong.com/test/PingFang.ttc");
        fontStyle.setSize(30);
        fontStyle.setStyle(Font.PLAIN);

        fontMap.put(DEFAULT_FONT, loadFont(fontStyle));
        log.debug("加载默认字体完成，加载地址：{}", fontStyle.getUrl());
    }

    public static Font loadFont(FontStyle fontStyle) {
        if (null == fontStyle.getName()) {
            fontStyle.setName(DEFAULT_FONT);
        }
        Font font = fontMap.get(fontStyle.getName());

        if (font == null) {
            try (InputStream inputStream = FileLoadUtil.load(fontStyle.getUrl(), true)) {
                if (null == inputStream) {
                    return null;
                }

                font = Font.createFont(Font.TRUETYPE_FONT, inputStream);
            } catch (FontFormatException | IOException e) {
                log.error(e.getMessage(), e);
            }
        }

        // 将参数中的px转换为pt
        float pt = fontStyle.getSize() * 3 / 4;
        return font.deriveFont(fontStyle.getStyle(), pt);
    }
}
