package com.bxm.component.poster.config;

import com.bxm.component.poster.template.PosterTemplate;
import com.bxm.component.poster.utils.XmlParser;
import com.bxm.newidea.component.tools.StringUtils;
import org.springframework.boot.context.properties.ConfigurationPropertiesBinding;
import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;

/**
 * 将配置中的xml解析为配置的海报模板
 *
 * @author liujia
 * @date 12/17/20 2:29 PM
 **/
@Component
@ConfigurationPropertiesBinding
public class XmlToTemplateConverter implements Converter<String, PosterTemplate> {

    @Override
    public PosterTemplate convert(String source) {
        if (StringUtils.isBlank(source)) {
            return null;
        }

        return XmlParser.parse(source);
    }
}