package com.bxm.component.poster.template.extend;

import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import lombok.Data;

import java.awt.*;

/**
 * 文字字体样式定义
 *
 * @author liujia
 * @date 12/17/20 11:25 AM
 **/
@Data
public class FontStyle {

    /**
     * 字体名称
     */
    @XStreamAsAttribute
    private String name;

    /**
     * 如果不在提供的默认字体列表中，则需要提供下载地址，该字体会被定义为「name」定义的名称
     */
    @XStreamAsAttribute
    private String url;

    /**
     * 字体大小
     */
    @XStreamAsAttribute
    private float size;

    /**
     * 字体样式选择，斜体、加粗等效果
     */
    @XStreamAsAttribute
    private int style = Font.PLAIN;

    /**
     * 文字是否显示删除线或者下划线
     * STRIKETHROUGH：删除线
     * UNDERLINE：下划线
     */
    @XStreamAsAttribute
    private String line;

    @XStreamAsAttribute
    private String weight;
}
