package com.bxm.component.poster.utils;

import com.bxm.component.poster.template.extend.FontStyle;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;

import java.awt.*;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

/**
 * @author liujia
 * @date 12/17/20 8:19 PM
 **/
@Slf4j
public class FontManage {
    private FontManage() {
    }

    private static final Map<String, Font> FONT_MAP = Maps.newHashMap();

    private static final String DEFAULT_FONT = "default";

    private static final AtomicBoolean INIT_FLAG = new AtomicBoolean();

    public static void init() {
        if (INIT_FLAG.compareAndSet(false, true)) {
            FontStyle fontStyle = new FontStyle();
            fontStyle.setName("default");
            fontStyle.setUrl("https://mtest.wstong.com/test/PingFang.ttc");
            fontStyle.setSize(30);
            fontStyle.setStyle(Font.PLAIN);

            FONT_MAP.put(DEFAULT_FONT, loadFont(fontStyle));

            if (log.isDebugEnabled()) {
                log.debug("加载默认字体完成，加载地址：{}", fontStyle.getUrl());
            }
        }
    }

    public static Font loadFont(FontStyle fontStyle) {
        if (null == fontStyle.getName()) {
            fontStyle.setName(DEFAULT_FONT);
        }
        Font font = FONT_MAP.get(fontStyle.getName());

        if (font == null) {
            try (InputStream inputStream = FileLoadUtil.load(fontStyle.getUrl(), true)) {
                if (null == inputStream) {
                    return null;
                }
                System.setProperty("java.awt.headless", "true");

                font = Font.createFont(Font.TRUETYPE_FONT, inputStream);
                log.info("字体[{}]加载成功", fontStyle.getName());
            } catch (FontFormatException | IOException e) {
                log.info("字体[{}]加载失败，请求地址：{}", fontStyle.getName(), fontStyle.getUrl());
                log.error(e.getMessage(), e);
            }
        }

        if (null == font) {
            log.error("仍然无法加载字体文件，请确认是否配置了对应的字体文件");
            return null;
        }

        // 将参数中的px转换为pt
        float pt = fontStyle.getSize() * 3 / 4;
        return font.deriveFont(fontStyle.getStyle(), pt);
    }
}
