package com.bxm.newidea.component.quartz.domain;

import com.bxm.newidea.component.quartz.vo.ScheduleJobBean;
import com.bxm.newidea.component.quartz.vo.ScheduleJobPageParam;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

@Mapper
public interface ScheduleViewMapper {

    /**
     * 根据任务名称和任务组名获取任务信息
     * @param jobName  任务名称
     * @param jobGroup 任务组
     * @return 定时任务详情
     */
    ScheduleJobBean selectByJobNameAndJobGroup(@Param("jobName") String jobName, @Param("jobGroup") String jobGroup);

    /**
     * 获取定时任务分页列表
     * @param scheduleJobPageParam 分页参数
     * @return 分页列表
     */
    List<ScheduleJobBean> selectByPageNumSize(ScheduleJobPageParam scheduleJobPageParam);
}