package com.bxm.newidea.component.quartz.service;

import com.bxm.newidea.component.quartz.AbstractCustomJob;
import com.bxm.newidea.component.quartz.vo.ScheduleJobBean;
import com.bxm.newidea.component.quartz.vo.ScheduleJobPageParam;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;

/**
 * 定时任务相关服务接口
 */
public interface ScheduleJobService {

    /**
     * 立即运行任务
     * @param jobName  任务名称
     * @param jobGroup 任务分组
     * @return 响应消息
     */
    Message run(String jobName, String jobGroup);

    /**
     * 添加一个简单运行策略的任务
     * @param job 任务信息
     * @return 添加结果
     */
    Message addSimpleJob(AbstractCustomJob job);

    /**
     * 添加cron表达式定时任务
     * @param job 任务信息
     * @return 添加结果
     */
    Message addCronJob(AbstractCustomJob job);

    /**
     * 恢复任务
     * @return 响应消息
     */
    Message resume(String jobName, String jobGroup);

    /**
     * 暂停任务
     * @param jobName  任务名称
     * @param jobGroup 任务分组
     * @return 响应消息
     */
    Message pause(String jobName, String jobGroup);

    /**
     * 更新任务
     * @param scheduleJobBean 传入的任务参数
     * @param scheduleJobBean 任务参数
     * @return 响应消息
     */
    Message update(ScheduleJobBean scheduleJobBean);

    /**
     * 删除任务
     * @param jobName  任务名称
     * @param jobGroup 任务分组
     * @return 响应消息
     */
    Message remove(String jobName, String jobGroup);

    /**
     * 获取定时任务分页列表
     * @param scheduleJobPageParam 分页参数
     * @return 响应消息
     */
    PageWarper<ScheduleJobBean> queryJobs(ScheduleJobPageParam scheduleJobPageParam);

    /**
     * 根据任务名称和任务分组获取定时任务信息
     * @param jobName  任务名称
     * @param jobGroup 任务分组
     * @return 定时任务信息
     */
    ScheduleJobBean getJob(String jobName, String jobGroup);

}
