package com.bxm.newidea.component.quartz.vo;

import com.bxm.newidea.component.vo.BaseBean;
import com.fasterxml.jackson.annotation.JsonIgnore;

import javax.validation.constraints.Max;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import java.util.Date;
import java.util.Map;

/**
 * 触发器实体类
 */
public class ScheduleJobBean extends BaseBean {

    @NotBlank
    @Size(max = 200, message = "任务名称最大长度为{max}")
    private String jobName;

    @Size(max = 200, message = "任务名称最大长度为{max}")
    private String jobGroup;

    @Size(max = 200, message = "任务描述最大长度为{max}")
    private String description;

    @Size(max = 200, message = "类名最大长度为{max}")
    private String clasz;

    @Max(value = Integer.MAX_VALUE, message = "优先级的最大值为{max}")
    private Integer priority;

    private String status;

    @NotBlank
    @Size(max = 200, message = "cron表达式的最大值为{max}")
    private String cronExpression;

    private Map param;

    @JsonIgnore
    private Long nextFireTime;

    @JsonIgnore
    private Long prevFireTime;

    private Date nextTime;

    private Date prevTime;

    public String getJobName() {
        return jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public String getJobGroup() {
        return jobGroup;
    }

    public void setJobGroup(String jobGroup) {
        this.jobGroup = jobGroup;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Integer getPriority() {
        return priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public String getClasz() {
        return clasz;
    }

    public void setClasz(String clasz) {
        this.clasz = clasz;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getCronExpression() {
        return cronExpression;
    }

    public void setCronExpression(String cronExpression) {
        this.cronExpression = cronExpression;
    }

    public Map getParam() {
        return param;
    }

    public void setParam(Map param) {
        this.param = param;
    }

    public Long getNextFireTime() {
        return nextFireTime;
    }

    public void setNextFireTime(Long nextFireTime) {
        this.nextFireTime = nextFireTime;
    }

    public Long getPrevFireTime() {
        return prevFireTime;
    }

    public void setPrevFireTime(Long prevFireTime) {
        this.prevFireTime = prevFireTime;
    }

    public Date getNextTime() {
        return nextTime;
    }

    public void setNextTime(Date nextTime) {
        this.nextTime = nextTime;
    }

    public Date getPrevTime() {
        return prevTime;
    }

    public void setPrevTime(Date prevTime) {
        this.prevTime = prevTime;
    }

}

