package com.bxm.newidea.component.redis;

import java.util.concurrent.TimeUnit;

/**
 * 基于redis实现的分布式锁
 * 提供一种较为简单的业务实现，复杂的逻辑实现调用底层对象来支撑
 *
 * @author liujia
 * @date 6/8/21 10:08 AM
 **/
public interface DistributedLock {

    /**
     * 锁定业务资源，防止并发情况对锁定的资源进行重复操作
     *
     * @param resource 锁定的资源
     * @return true表示加锁成功，可进行后续业务，false表示加锁失败，需要进行适当的重试机制
     */
    boolean lock(String resource);

    /**
     * 锁定业务资源，防止并发情况对锁定的资源进行重复操作
     *
     * @param resource 锁定的资源,如业务ID、编码等
     * @param time     加锁的时长
     * @param timeUnit 加锁时间的单位
     * @return true表示加锁成功，可进行后续业务
     */
    boolean lock(String resource, long time, TimeUnit timeUnit);

    /**
     * 解锁资源
     *
     * @param resource 解锁的资源,如业务ID、编码等
     */
    void unlock(String resource);
}
