/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.redis.impl;

import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.tools.StringUtils;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultKeyGenerator
implements KeyGenerator {
    private static final Logger log = LoggerFactory.getLogger(DefaultKeyGenerator.class);
    private String module;
    private String group;
    private String key;
    private boolean copyObj;

    private DefaultKeyGenerator(String module, String group, String key) {
        this.setGroup(group).setModule(module).setKey(key);
    }

    private DefaultKeyGenerator(String module, String group) {
        this.setGroup(group).setModule(module);
    }

    private DefaultKeyGenerator() {
    }

    public static DefaultKeyGenerator build() {
        return new DefaultKeyGenerator();
    }

    public static DefaultKeyGenerator build(String module, String group) {
        return new DefaultKeyGenerator(module, group);
    }

    public static DefaultKeyGenerator build(String module, String group, String key) {
        return new DefaultKeyGenerator(module, group, key);
    }

    private static DefaultKeyGenerator build(DefaultKeyGenerator key) {
        return new DefaultKeyGenerator(key.module, key.group, key.key);
    }

    @Override
    public DefaultKeyGenerator setModule(String module) {
        this.module = module;
        return this;
    }

    @Override
    public DefaultKeyGenerator setGroup(String group) {
        this.group = group;
        return this;
    }

    @Override
    public DefaultKeyGenerator setKey(String key) {
        this.key = key;
        return this;
    }

    String getKey() {
        return this.key;
    }

    boolean isCopyObj() {
        return this.copyObj;
    }

    void setCopyObj(boolean copyObj) {
        this.copyObj = copyObj;
    }

    @Override
    public DefaultKeyGenerator appendKey(Object subKey) {
        DefaultKeyGenerator generator;
        if (this.isCopyObj()) {
            generator = this;
        } else {
            log.warn("\u672a\u8c03\u7528#copy()\u65b9\u6cd5\uff0c\u521b\u5efa\u4e86\u65b0\u5bf9\u8c61\uff0c\u8bf7\u6ce8\u610f\u63a5\u6536\u8fd4\u56de\u503c");
            generator = this.copy();
        }
        if (Objects.isNull(subKey)) {
            return generator;
        }
        if (StringUtils.isBlank((CharSequence)generator.getKey())) {
            generator.setKey(subKey.toString());
        } else {
            generator.setKey(generator.getKey() + ":" + subKey.toString());
        }
        return generator;
    }

    @Override
    public String gen() {
        String redisKey = this.module + ":" + this.group + ":" + this.key;
        if (redisKey.length() > 150) {
            log.warn("\u7f13\u5b58\u952e\u503c\u8bbe\u8ba1\u8fc7\u957f\uff0c\u8bf7\u7f29\u77ed\u5b9e\u9645\u4fdd\u5b58\u7684\u952e\uff0c\u4f7f\u7528\u53d8\u91cf\u540d\u6765\u4fdd\u8bc1\u53ef\u9605\u8bfb\u6027,\u952e\uff1a{}", (Object)redisKey);
        }
        return redisKey;
    }

    @Override
    public DefaultKeyGenerator copy() {
        DefaultKeyGenerator keyGenerator = DefaultKeyGenerator.build(this);
        keyGenerator.setCopyObj(true);
        return keyGenerator;
    }

    @Override
    public String toString() {
        return this.gen();
    }
}

