/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.redis.utils;

import com.bxm.newidea.component.redis.DistributedLock;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.redis.utils.RedisPermits;
import com.google.common.math.LongMath;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RateLimiter {
    private static final Logger log = LoggerFactory.getLogger(RateLimiter.class);
    private KeyGenerator key;
    private String lockKey;
    private Double permitsPerSecond;
    private Integer maxBurstSeconds;
    private DistributedLock syncLock;
    private RedisStringAdapter redisStringAdapter;

    RateLimiter(KeyGenerator key, Double permitsPerSecond, Integer maxBurstSeconds, DistributedLock syncLock, RedisStringAdapter redisStringAdapter) {
        this.key = key;
        this.lockKey = key.gen();
        this.permitsPerSecond = permitsPerSecond;
        this.maxBurstSeconds = maxBurstSeconds;
        this.syncLock = syncLock;
        this.redisStringAdapter = redisStringAdapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RedisPermits putDefaultPermits() {
        this.lock();
        try {
            RedisPermits obj = this.redisStringAdapter.get(this.key, RedisPermits.class);
            if (null == obj) {
                RedisPermits permits = new RedisPermits(this.permitsPerSecond, this.maxBurstSeconds);
                this.redisStringAdapter.set(this.key, permits, permits.expires());
                RedisPermits redisPermits = permits;
                return redisPermits;
            }
            RedisPermits redisPermits = obj;
            return redisPermits;
        }
        finally {
            this.unlock();
        }
    }

    private void lock() {
        this.syncLock.lock(this.lockKey, "1", 10L, TimeUnit.SECONDS);
    }

    private void unlock() {
        this.syncLock.unlock(this.lockKey, "1");
    }

    private RedisPermits getPermits() {
        RedisPermits obj = this.redisStringAdapter.get(this.key, RedisPermits.class);
        if (null == obj) {
            return this.putDefaultPermits();
        }
        return obj;
    }

    private void setPermits(RedisPermits permits) {
        this.redisStringAdapter.set(this.key, permits, permits.expires());
    }

    public Long acquire(Long tokens) throws InterruptedException {
        long milliToWait = this.reserve(tokens);
        log.info("acquire {} for {} ms", (Object)tokens, (Object)milliToWait);
        Thread.sleep(milliToWait);
        return milliToWait;
    }

    public long acquire() throws InterruptedException {
        return this.acquire(1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean tryAcquire(Long tokens, Long timeout, TimeUnit unit) throws InterruptedException {
        Long milliToWait;
        long timeoutMicros = Math.max(unit.toMillis(timeout), 0L);
        this.checkTokens(tokens);
        try {
            this.lock();
            if (!this.canAcquire(tokens, timeoutMicros).booleanValue()) {
                Boolean bl = false;
                return bl;
            }
            milliToWait = this.reserveAndGetWaitLength(tokens);
        }
        finally {
            this.unlock();
        }
        Thread.sleep(milliToWait);
        return true;
    }

    public Boolean tryAcquire(Long timeout, TimeUnit unit) throws InterruptedException {
        return this.tryAcquire(1L, timeout, unit);
    }

    private long redisNow() {
        return System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long reserve(Long tokens) {
        this.checkTokens(tokens);
        try {
            this.lock();
            long l = this.reserveAndGetWaitLength(tokens);
            return l;
        }
        finally {
            this.unlock();
        }
    }

    private void checkTokens(Long tokens) {
        if (tokens < 0L) {
            throw new IllegalArgumentException("Requested tokens " + tokens + " must be positive");
        }
    }

    private Boolean canAcquire(Long tokens, Long timeoutMillis) {
        return this.queryEarliestAvailable(tokens) - timeoutMillis <= 0L;
    }

    private Long queryEarliestAvailable(Long tokens) {
        long n = this.redisNow();
        RedisPermits permit = this.getPermits();
        permit.reSync(n);
        long storedPermitsToSpend = Math.min(tokens, permit.getStoredPermits());
        long freshPermits = tokens - storedPermitsToSpend;
        long waitMillis = freshPermits * permit.getIntervalMillis();
        return LongMath.saturatedAdd((long)(permit.getNextFreeTicketMillis() - n), (long)waitMillis);
    }

    private Long reserveAndGetWaitLength(Long tokens) {
        long n = this.redisNow();
        RedisPermits permit = this.getPermits();
        permit.reSync(n);
        long storedPermitsToSpend = Math.min(tokens, permit.getStoredPermits());
        long freshPermits = tokens - storedPermitsToSpend;
        long waitMillis = freshPermits * permit.getIntervalMillis();
        permit.setNextFreeTicketMillis(LongMath.saturatedAdd((long)permit.getNextFreeTicketMillis(), (long)waitMillis));
        permit.setStoredPermits(permit.getStoredPermits() - storedPermitsToSpend);
        this.setPermits(permit);
        return permit.getNextFreeTicketMillis() - n;
    }
}

