/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.redis.impl;

import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.impl.BaseRedisAdapter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class RedisHashMapAdapterImpl
extends BaseRedisAdapter
implements RedisHashMapAdapter {
    private HashOperations<String, String, Object> hashOperations;

    @Autowired
    public RedisHashMapAdapterImpl(RedisTemplate<String, Object> redisTemplate) {
        super(redisTemplate);
        this.hashOperations = redisTemplate.opsForHash();
    }

    @Override
    public void put(KeyGenerator generator, String subKey, Object value) {
        Assert.notNull((Object)generator, (String)"key\u6784\u5efa\u5668\u5fc5\u987b\u4f20\u9012");
        this.hashOperations.put((Object)generator.gen(), (Object)subKey, (Object)this.serializer.serialize(value));
    }

    @Override
    public void putLong(KeyGenerator generator, String subKey, Long value) {
        this.hashOperations.put((Object)generator.gen(), (Object)subKey, (Object)value);
    }

    @Override
    public void putAll(KeyGenerator generator, Map<String, ? extends Object> values) {
        if (values == null) {
            return;
        }
        HashMap convertResult = new HashMap();
        values.forEach((key, value) -> convertResult.put(key, this.serializer.serialize(value)));
        this.hashOperations.putAll((Object)generator.gen(), convertResult);
    }

    @Override
    public <T> T get(KeyGenerator generator, String subKey) {
        String key = generator.gen();
        Object value = this.hashOperations.get((Object)key, (Object)subKey);
        if (null == value) {
            return null;
        }
        return this.deserialize(value);
    }

    @Override
    public <T> T redisGet(String key, String subKey) {
        Object value = this.hashOperations.get((Object)key, (Object)subKey);
        if (null == value) {
            return null;
        }
        return this.deserialize(value);
    }

    @Override
    public Set<String> keys(KeyGenerator generator) {
        return this.hashOperations.keys((Object)generator.gen());
    }

    @Override
    public <T> List<T> values(KeyGenerator generator) {
        List result = this.hashOperations.values((Object)generator.gen());
        return result.stream().map(item -> this.serializer.deserialize((byte[])item)).collect(Collectors.toList());
    }

    @Override
    public <T> Map<String, T> entries(KeyGenerator generator) {
        ScanOptions.scanOptions().build();
        Cursor cursor = this.hashOperations.scan((Object)generator.gen(), ScanOptions.scanOptions().count(10000L).build());
        HashMap result = new HashMap();
        Map.Entry entry = null;
        while (cursor.hasNext()) {
            entry = (Map.Entry)cursor.next();
            result.put(entry.getKey(), this.serializer.deserialize((byte[])entry.getValue()));
        }
        return result;
    }

    @Override
    public boolean exists(KeyGenerator generator, String subKey) {
        return this.hashOperations.hasKey((Object)generator.gen(), (Object)subKey);
    }

    @Override
    public long remove(KeyGenerator generator, String ... subKeys) {
        if (ArrayUtils.isEmpty((Object[])subKeys)) {
            return 0L;
        }
        return this.hashOperations.delete((Object)generator.gen(), (Object[])subKeys);
    }

    @Override
    public long length(KeyGenerator generator) {
        return this.hashOperations.size((Object)generator.gen());
    }

    @Override
    public long increment(KeyGenerator generator, String subKey, int amount) {
        return this.hashOperations.increment((Object)generator.gen(), (Object)subKey, (long)amount);
    }
}

