/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.redis.impl;

import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.redis.impl.BaseRedisAdapter;
import java.util.HashSet;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.SetOperations;
import org.springframework.stereotype.Component;

@Component
public class RedisSetAdapterImpl
extends BaseRedisAdapter
implements RedisSetAdapter {
    private SetOperations operations;

    @Autowired
    public RedisSetAdapterImpl(RedisTemplate<String, Object> redisTemplate) {
        super(redisTemplate);
        this.operations = redisTemplate.opsForSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long add(KeyGenerator generator, Object ... values) {
        String key = generator.gen();
        try {
            this.redisTemplate.watch((Object)key);
            this.redisTemplate.multi();
            long l = this.operations.add((Object)generator.gen(), (Object[])this.serialize(values));
            return l;
        }
        finally {
            this.redisTemplate.unwatch();
        }
    }

    @Override
    public long remove(KeyGenerator generator, Object ... values) {
        return this.operations.remove((Object)generator.gen(), (Object[])this.serialize(values));
    }

    @Override
    public boolean exists(KeyGenerator generator, Object value) {
        return this.operations.isMember((Object)generator.gen(), (Object)this.serializer.serialize(value));
    }

    @Override
    public long size(KeyGenerator generator) {
        return this.operations.size((Object)generator.gen());
    }

    @Override
    public <T> Set<T> getAllMembers(KeyGenerator generator) {
        Cursor cursor = this.operations.scan((Object)generator.gen(), ScanOptions.scanOptions().count(10000L).build());
        HashSet result = new HashSet();
        while (cursor.hasNext()) {
            result.add(this.deserialize(cursor.next()));
        }
        return result;
    }

    private <T> Set<T> deserialize(Set<Object> data) {
        HashSet result = new HashSet();
        if (null != data && data.size() > 0) {
            data.forEach(item -> result.add(this.serializer.deserialize((byte[])item)));
        }
        return result;
    }

    @Override
    public <T> Set<T> difference(KeyGenerator generator, KeyGenerator ... otherGenerators) {
        return this.deserialize(this.operations.difference((Object)generator.gen(), this.convertKeys(otherGenerators)));
    }

    @Override
    public long differenceAndStore(KeyGenerator storeGenerator, KeyGenerator generator, KeyGenerator ... otherGenerators) {
        if (storeGenerator == null) {
            return 0L;
        }
        return this.operations.differenceAndStore((Object)generator.gen(), this.convertKeys(otherGenerators), (Object)storeGenerator.gen());
    }

    @Override
    public <T> Set<T> inter(KeyGenerator generator, KeyGenerator ... otherGenerators) {
        return this.deserialize(this.operations.intersect((Object)generator.gen(), this.convertKeys(otherGenerators)));
    }

    @Override
    public long interAndStore(KeyGenerator storeGenerator, KeyGenerator generator, KeyGenerator ... otherGenerators) {
        if (storeGenerator == null) {
            return 0L;
        }
        return this.operations.intersectAndStore((Object)generator.gen(), this.convertKeys(otherGenerators), (Object)storeGenerator.gen());
    }

    @Override
    public <T> Set<T> union(KeyGenerator generator, KeyGenerator ... otherGenerators) {
        return this.deserialize(this.operations.union((Object)generator.gen(), this.convertKeys(otherGenerators)));
    }

    @Override
    public long unionAndStore(KeyGenerator storeGenerator, KeyGenerator generator, KeyGenerator ... otherGenerators) {
        if (storeGenerator == null) {
            return 0L;
        }
        return this.operations.unionAndStore((Object)generator.gen(), this.convertKeys(otherGenerators), (Object)storeGenerator.gen());
    }

    @Override
    public boolean move(KeyGenerator sourceKey, KeyGenerator targetKey, Object item) {
        return this.operations.move((Object)sourceKey.gen(), (Object)this.serializer.serialize(item), (Object)targetKey.gen());
    }

    @Override
    public SetOperations getOriginal() {
        return this.operations;
    }
}

