/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.redis.serializer;

import com.bxm.newidea.component.redis.serializer.Kryox;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KryoSerializer {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final byte[] EMPTY_ARRAY = new byte[0];
    private static ThreadLocal<Kryox> kryoThreadLocal = ThreadLocal.withInitial(Kryox::new);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] serialize(Object o) {
        if (o == null) {
            return EMPTY_ARRAY;
        }
        Kryo kryo = kryoThreadLocal.get();
        Output output = new Output(64, -1);
        try {
            kryo.writeClassAndObject(output, o);
            byte[] byArray = output.toBytes();
            return byArray;
        }
        finally {
            this.closeOutputStream((OutputStream)output);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T deserialize(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        Kryo kryo = kryoThreadLocal.get();
        Input input = null;
        try {
            input = new Input(bytes);
            Object object = kryo.readClassAndObject(input);
            return (T)object;
        }
        finally {
            this.closeInputStream((InputStream)input);
        }
    }

    private void closeOutputStream(OutputStream output) {
        if (output != null) {
            try {
                output.flush();
                output.close();
            }
            catch (Exception e) {
                this.logger.error("serialize object close outputStream exception", (Throwable)e);
            }
        }
    }

    private void closeInputStream(InputStream input) {
        if (input != null) {
            try {
                input.close();
            }
            catch (Exception e) {
                this.logger.error("serialize object close inputStream exception", (Throwable)e);
            }
        }
    }
}

