/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.redis.serializer;

import com.dyuproject.protostuff.LinkedBuffer;
import com.dyuproject.protostuff.ProtostuffIOUtil;
import com.dyuproject.protostuff.Schema;
import com.dyuproject.protostuff.runtime.RuntimeSchema;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.objenesis.Objenesis;
import org.objenesis.ObjenesisStd;

public class ProtostuffSerializer {
    private static Map<Class<?>, Schema<?>> cachedSchema = new ConcurrentHashMap();
    private static Objenesis objenesis = new ObjenesisStd(true);

    private static <T> Schema<T> getSchema(Class<T> clazz) {
        Schema schema = cachedSchema.get(clazz);
        if (schema == null && (schema = RuntimeSchema.getSchema(clazz)) != null) {
            cachedSchema.put(clazz, schema);
        }
        return schema;
    }

    public static <T> byte[] serialize(T obj) {
        Class<?> clazz = obj.getClass();
        LinkedBuffer buffer = LinkedBuffer.allocate((int)512);
        try {
            Schema<?> schema = ProtostuffSerializer.getSchema(clazz);
            byte[] byArray = ProtostuffIOUtil.toByteArray(obj, schema, (LinkedBuffer)buffer);
            return byArray;
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        finally {
            buffer.clear();
        }
    }

    public static <T> T deserialize(byte[] data, Class<T> clazz) {
        try {
            Schema<T> schema = ProtostuffSerializer.getSchema(clazz);
            if (schema == null) {
                return null;
            }
            Object obj = schema.newMessage();
            ProtostuffIOUtil.mergeFrom((byte[])data, (Object)obj, schema);
            return (T)obj;
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }
}

