package com.bxm.newidea.component.redis.serializer;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import sun.reflect.ReflectionFactory;

import com.esotericsoftware.kryo.Kryo;

/**
 * 解决无参构造函数无法序列化的问题
 */
public class Kryox extends Kryo {

    private static Log logger = LogFactory.getLog("busiLog");

    @SuppressWarnings("restriction")
    private final ReflectionFactory REFLECTION_FACTORY = ReflectionFactory.getReflectionFactory();

    private final ConcurrentHashMap<Class<?>, Constructor<?>> _constructors = new ConcurrentHashMap<Class<?>, Constructor<?>>();

    private final ConcurrentHashMap<Class<?>, Boolean> _hasConstructor = new ConcurrentHashMap<>();

    public Kryox(){
        super();
        this.setRegistrationRequired(false);
    }

    @Override
    public <T> T newInstance(Class<T> type) {
        try {
            Boolean typeHasStructor = _hasConstructor.get(type);
            if(typeHasStructor == null){
                _hasConstructor.put(type,Boolean.TRUE);
                return super.newInstance(type);
            }else{
                if(typeHasStructor){
                    return super.newInstance(type);
                }else{
                    return (T) newInstanceFromReflectionFactory(type);
                }
            }

        } catch (Exception e) {
            _hasConstructor.put(type,Boolean.FALSE);
            return (T) newInstanceFromReflectionFactory(type);
        }
    }

    private Object newInstanceFrom(Constructor<?> constructor) {
        try {
            return constructor.newInstance();
        } catch (final Exception e) {
            throw new RuntimeException(e);
        }
    }

    @SuppressWarnings("unchecked")
    public <T> T newInstanceFromReflectionFactory(Class<T> type) {
        Constructor<?> constructor = _constructors.get(type);
        if (constructor == null) {
            constructor = newConstructorForSerialization(type);
            Constructor<?> saved = _constructors.putIfAbsent(type, constructor);
            if (saved != null)
                constructor = saved;
        }
        return (T) newInstanceFrom(constructor);
    }

    private <T> Constructor<?> newConstructorForSerialization(Class<T> type) {
        try {
            Constructor<?> constructor = REFLECTION_FACTORY.newConstructorForSerialization(type, Object.class.getDeclaredConstructor());
            constructor.setAccessible(true);
            return constructor;
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

}