/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.redis.impl;

import com.bxm.newidea.component.redis.BaseRedisOperation;
import com.bxm.newidea.component.redis.KeyGenerator;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.Jackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.util.CollectionUtils;

public class BaseRedisAdapter
implements BaseRedisOperation {
    RedisTemplate<String, Object> redisTemplate;
    RedisSerializer<String> stringSerializer;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public BaseRedisAdapter(RedisTemplate<String, Object> redisTemplate) {
        this.redisTemplate = redisTemplate;
        this.stringSerializer = new StringRedisSerializer();
    }

    @Override
    public Boolean remove(KeyGenerator key) {
        return this.redisTemplate.delete((Object)key.gen());
    }

    @Override
    public Long remove(List<KeyGenerator> keys) {
        if (CollectionUtils.isEmpty(keys)) {
            return 0L;
        }
        List finalKeys = keys.stream().map(KeyGenerator::gen).collect(Collectors.toList());
        return this.redisTemplate.delete(finalKeys);
    }

    @Override
    public void expire(KeyGenerator key, long seconds) {
        if (seconds > 0L) {
            this.redisTemplate.expire((Object)key.gen(), seconds, TimeUnit.SECONDS);
        }
    }

    @Override
    public void expire(KeyGenerator key, Date expiredDate) {
        if (null != expiredDate) {
            this.redisTemplate.expireAt((Object)key.gen(), expiredDate);
        }
    }

    @Override
    public Boolean hasKey(KeyGenerator key) {
        return this.redisTemplate.hasKey((Object)key.gen());
    }

    <T> RedisSerializer getSerializer(Class<T> clasz) {
        return new Jackson2JsonRedisSerializer(clasz);
    }

    RedisSerializer getSerializerWithoutType() {
        return new Jackson2JsonRedisSerializer(Object.class);
    }

    <T> T deserialize(Object value, Class<T> clasz) {
        if (value instanceof byte[]) {
            return (T)this.getSerializer(clasz).deserialize((byte[])value);
        }
        this.logger.warn("redis\u8fd4\u56de\u6570\u636e\u4e0d\u80fd\u8fdb\u884c\u53cd\u5e8f\u5217\u5316\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u914d\u7f6e\u4e86\u81ea\u5b9a\u4e49\u7684\u5e8f\u5217");
        return null;
    }

    protected byte[][] serialize(String[] values) {
        byte[][] result = new byte[values.length][];
        for (int i = 0; i < values.length; ++i) {
            result[i] = this.stringSerializer.serialize((Object)values[i]);
        }
        return result;
    }

    <T> byte[][] serialize(Object[] values, Class<T> clasz) {
        byte[][] result = new byte[values.length][];
        for (int i = 0; i < values.length; ++i) {
            result[i] = this.getSerializer(clasz).serialize(values[i]);
        }
        return result;
    }

    <T> byte[][] serializeWithoutType(T[] values) {
        return this.serialize(values, Object.class);
    }

    List<String> convertKeys(KeyGenerator ... generators) {
        if (ArrayUtils.isEmpty((Object[])generators)) {
            return null;
        }
        ArrayList<String> keys = new ArrayList<String>();
        for (KeyGenerator generator : generators) {
            keys.add(generator.gen());
        }
        return keys;
    }
}

