/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.redis.impl;

import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.redis.impl.BaseRedisAdapter;
import com.bxm.newidea.component.tools.NumberUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.stereotype.Component;

@Component
public class RedisStringAdapterImpl
extends BaseRedisAdapter
implements RedisStringAdapter {
    private ValueOperations operations;

    @Autowired
    public RedisStringAdapterImpl(RedisTemplate redisTemplate) {
        super((RedisTemplate<String, Object>)redisTemplate);
        this.operations = redisTemplate.opsForValue();
    }

    @Override
    public Long increment(KeyGenerator generator) {
        return this.increment(generator, 1);
    }

    @Override
    public Long increment(KeyGenerator generator, int amount) {
        return this.incrementWithDefault(generator, 1L, amount, 0L);
    }

    @Override
    public Long increment(KeyGenerator generator, long expireSeconds) {
        return this.incrementWithDefault(generator, 1L, 1, expireSeconds);
    }

    @Override
    public Long incrementWithDefault(KeyGenerator generator, long defaultVal) {
        return this.incrementWithDefault(generator, defaultVal, 1, 0L);
    }

    @Override
    public Long incrementWithDefault(KeyGenerator generator, long defaultVal, int amount) {
        return this.incrementWithDefault(generator, defaultVal, amount, 0L);
    }

    @Override
    public Long incrementWithDefault(KeyGenerator generator, long defaultVal, int amount, long expireSeconds) {
        return this.exec(generator, defaultVal, amount, expireSeconds, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Long exec(KeyGenerator generator, long defaultVal, int amount, long expireSeconds, boolean isIncrement) {
        String key = generator.gen();
        try {
            this.redisTemplate.watch((Object)key);
            this.redisTemplate.multi();
            if (!this.hasKey(generator).booleanValue()) {
                this.operations.set((Object)key, (Object)Objects.requireNonNull(this.stringSerializer.serialize((Object)(defaultVal + ""))));
                this.expire(generator, expireSeconds);
                Long l = defaultVal;
                return l;
            }
            amount = isIncrement ? amount : -amount;
            Long l = this.operations.increment((Object)key, (long)amount);
            return l;
        }
        finally {
            this.redisTemplate.unwatch();
        }
    }

    @Override
    public Long decrement(KeyGenerator generator, long defaultVal, int amount, long expireSeconds) {
        return this.exec(generator, defaultVal, amount, expireSeconds, false);
    }

    @Override
    public Long decrement(KeyGenerator generator) {
        return this.decrement(generator, 1L, 1, 0L);
    }

    @Override
    public Long decrement(KeyGenerator generator, int amount) {
        return this.decrement(generator, 1L, amount, 0L);
    }

    @Override
    public Long decrement(KeyGenerator generator, long expireSeconds) {
        return this.decrement(generator, 1L, 1, expireSeconds);
    }

    @Override
    public Long decrement(KeyGenerator generator, long defaultVal, int amount) {
        return this.decrement(generator, defaultVal, amount, 0L);
    }

    @Override
    public Long getLong(KeyGenerator generator) {
        return NumberUtils.parseToLong((String)this.getString(generator));
    }

    @Override
    public Integer getInt(KeyGenerator generator) {
        return NumberUtils.parseToInt((String)this.getString(generator));
    }

    @Override
    public String getString(KeyGenerator generator) {
        Object value = this.operations.get((Object)generator.gen());
        if (null == value) {
            return "";
        }
        return (String)this.stringSerializer.deserialize((byte[])value);
    }

    @Override
    public <T> T get(KeyGenerator generator, Class<T> clasz) {
        Object value = this.operations.get((Object)generator.gen());
        if (null == value) {
            return null;
        }
        return (T)this.getSerializer(clasz).deserialize((byte[])value);
    }

    @Override
    public <T> T get(KeyGenerator generator, TypeReference<T> typeReference) {
        Object value = this.operations.get((Object)generator.gen());
        if (null == value) {
            return null;
        }
        return (T)this.getSerializer(typeReference).deserialize((byte[])value);
    }

    @Override
    public <T> void set(KeyGenerator generator, T value) {
        this.operations.set((Object)generator.gen(), (Object)Objects.requireNonNull(this.getSerializerWithoutType().serialize(value)));
    }

    @Override
    public void set(KeyGenerator generator, long value) {
        this.operations.set((Object)generator.gen(), (Object)Objects.requireNonNull(this.stringSerializer.serialize((Object)Long.toString(value))));
    }

    @Override
    public <T> void set(KeyGenerator generator, T value, long expireSeconds) {
        this.operations.set((Object)generator.gen(), (Object)Objects.requireNonNull(this.getSerializerWithoutType().serialize(value)), expireSeconds, TimeUnit.SECONDS);
    }
}

