package com.bxm.newidea.component.redisson.config;

import io.netty.channel.nio.NioEventLoopGroup;
import lombok.Data;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.client.codec.StringCodec;
import org.redisson.config.BaseConfig;
import org.redisson.config.ClusterServersConfig;
import org.redisson.config.Config;
import org.redisson.config.SingleServerConfig;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * @author lowi
 * @date 2021/5/13 10:04
 */
@Configuration
@Data
@EnableConfigurationProperties(RedissonProperties.class)
public class RedisConfigBean {

    private RedissonProperties redissonProperties;

    public RedisConfigBean(RedissonProperties redissonProperties) {
        this.redissonProperties = redissonProperties;
    }


    @Bean
    RedissonClient redisson() throws Exception {
        Config config = new Config();
        if (redissonProperties.getType() == null || redissonProperties.getType() == 1) {
            return useSingleServer(config);
        } else {
            return clusterServersConfig(config);
        }
    }


    private RedissonClient useSingleServer(Config config) {
        config.useSingleServer()
                .setAddress(redissonProperties.getAddress())
                .setConnectionMinimumIdleSize(redissonProperties.getConnectionMinimumIdleSize())
                .setConnectionPoolSize(redissonProperties.getConnectionPoolSize())
                .setDatabase(redissonProperties.getDatabase())
                .setDnsMonitoringInterval(redissonProperties.getDnsMonitoringInterval())
                .setSubscriptionConnectionMinimumIdleSize(redissonProperties.getSubscriptionConnectionMinimumIdleSize())
                .setSubscriptionConnectionPoolSize(redissonProperties.getSubscriptionConnectionPoolSize())
                .setSubscriptionsPerConnection(redissonProperties.getSubscriptionsPerConnection())
                .setClientName(redissonProperties.getClientName())
                .setRetryAttempts(redissonProperties.getRetryAttempts())
                .setRetryInterval(redissonProperties.getRetryInterval())
                .setTimeout(redissonProperties.getTimeout())
                .setConnectTimeout(redissonProperties.getConnectTimeout())
                .setIdleConnectionTimeout(redissonProperties.getIdleConnectionTimeout())
                .setPassword(redissonProperties.getPassword());
        config.setCodec(new StringCodec());
        config.setThreads(redissonProperties.getThread());
        config.setEventLoopGroup(new NioEventLoopGroup());
        return Redisson.create(config);
    }

    private RedissonClient clusterServersConfig(Config config) {
        config.useClusterServers()
                .addNodeAddress(redissonProperties.getAddress())
                .setPassword(redissonProperties.getPassword());
        config.setCodec(new StringCodec());
        config.setThreads(redissonProperties.getThread());
        config.setEventLoopGroup(new NioEventLoopGroup());
        return Redisson.create(config);
    }
}
