package com.bxm.newidea.component.redisson.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * @author lowi
 * @date 2021/5/24 17:06
 */

@ConfigurationProperties(prefix = "compnoent.redisson")
@Data
public class RedissonProperties {

    private String address = "redis://lowi.centos1.com:6379";
    private int connectionMinimumIdleSize = 10;
    private int idleConnectionTimeout = 10000;
    private int pingTimeout = 1000;
    private int connectTimeout = 10000;
    private int timeout = 3000;
    private int retryAttempts = 3;
    private int retryInterval = 1500;
    private int reconnectionTimeout = 3000;
    private int failedAttempts = 3;
    private String password = "123456";
    private int subscriptionsPerConnection = 5;
    private String clientName = null;
    private int subscriptionConnectionMinimumIdleSize = 1;
    private int subscriptionConnectionPoolSize = 50;
    private int connectionPoolSize = 64;
    private int database = 3;
    private boolean dnsMonitoring = false;
    private int dnsMonitoringInterval = 5000;

    private int thread = 4;

    private Integer type;


}
