package com.bxm.newidea.component.redisson.impl;

import com.bxm.newidea.component.redis.HyperLogLogAdapter;
import com.bxm.newidea.component.redis.KeyGenerator;
import org.redisson.api.RHyperLogLog;
import org.redisson.api.RedissonClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

@Component
public class HyperLogLogAdapterImpl extends BaseRedisAdapter implements HyperLogLogAdapter {


    @Autowired
    public HyperLogLogAdapterImpl(RedissonClient redissonClient) {
        super(redissonClient);
    }

    private RHyperLogLog hyperLogLogOperations(KeyGenerator keyGenerator) {
        return redissonClient.getHyperLogLog(keyGenerator.gen());
    }


    @SafeVarargs
    @Override
    public final <T> Long add(KeyGenerator keyGenerator, T... value) {
        AtomicLong atomicLong = new AtomicLong();
        for (T t : value) {
            boolean add = hyperLogLogOperations(keyGenerator).add(this.serializerString(t));
            atomicLong.addAndGet(add ? 1 : 0);
        }
        return atomicLong.get();
    }

    @Override
    public Long size(KeyGenerator... keyGenerators) {
        if (keyGenerators.length == 0) {
            return 0L;
        }
        List<String> strings = convertKeysNotFirst(keyGenerators);
        return hyperLogLogOperations(keyGenerators[0]).countWith(strings.stream().toArray(String[]::new));
    }


    @Override
    public Long union(KeyGenerator keyGenerator, KeyGenerator... sourceKeyGenerators) {
        String[] keyGeneratorArray = Arrays.stream(sourceKeyGenerators).map(KeyGenerator::gen).toArray(String[]::new);
        hyperLogLogOperations(keyGenerator).mergeWith(keyGeneratorArray);
        return hyperLogLogOperations(keyGenerator).countWith();
    }

    @Override
    public Boolean remove(KeyGenerator keyGenerator) {
        return hyperLogLogOperations(keyGenerator).delete();
    }
}
