package com.bxm.newidea.component.redisson.config;

import org.redisson.api.RedissonClient;
import org.springframework.cglib.proxy.MethodInterceptor;
import org.springframework.cglib.proxy.MethodProxy;
import org.springframework.util.ReflectionUtils;

import java.lang.reflect.Method;

/**
 * 代理执行方法，在真正需要被调用的时候才去执行redis的初始化
 * 不要在正式环境使用，防止redis连接失败仍然正常启动
 *
 * @author liujia
 * @date 7/22/21 8:16 PM
 **/
public class RedissonMethodInterceptor implements MethodInterceptor {

    private RedissonClientHolder redissonClientHolder;

    private RedissonMetaInfo redissonMetaInfo;

    private String dbName;

    public RedissonMethodInterceptor(RedissonClientHolder redissonClientHolder,
                                     RedissonMetaInfo redissonMetaInfo,
                                     String dbName) {
        this.redissonClientHolder = redissonClientHolder;
        this.redissonMetaInfo = redissonMetaInfo;
        this.dbName = dbName;
    }

    @Override
    public Object intercept(Object o, Method method, Object[] objects, MethodProxy methodProxy) throws Throwable {
        RedissonClient client = redissonClientHolder.get(dbName, redissonMetaInfo);

        return ReflectionUtils.invokeMethod(method, client, objects);
    }
}
