/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.redisson.impl;

import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redisson.config.SwitchMultiDataSourceHandler;
import com.bxm.newidea.component.redisson.impl.BaseRedisAdapter;
import com.bxm.newidea.component.tools.NumberUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.redisson.api.RMap;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.StringCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class RedissonHashMapAdapterImpl
extends BaseRedisAdapter
implements RedisHashMapAdapter {
    private static final Logger log = LoggerFactory.getLogger(RedissonHashMapAdapterImpl.class);

    public RedissonHashMapAdapterImpl(SwitchMultiDataSourceHandler switchMultiDataSourceHandler) {
        super(switchMultiDataSourceHandler);
    }

    private RMap hashOperations(KeyGenerator generator) {
        return this.switchMultiDataSourceHandler.getRedissonClient(generator.getDbName()).getMap(generator.gen());
    }

    private RMap numericHashOperations(KeyGenerator generator) {
        return this.switchMultiDataSourceHandler.getRedissonClient(generator.getDbName()).getMap(generator.gen(), (Codec)StringCodec.INSTANCE);
    }

    public <T> void put(KeyGenerator generator, String subKey, T value) {
        Assert.notNull((Object)generator, (String)"key\u6784\u5efa\u5668\u5fc5\u987b\u4f20\u9012");
        this.hashOperations(generator).put((Object)subKey, (Object)this.serializerString(value));
    }

    public <T> void fastPut(KeyGenerator generator, String subKey, T value) {
        Assert.notNull((Object)generator, (String)"key\u6784\u5efa\u5668\u5fc5\u987b\u4f20\u9012");
        this.hashOperations(generator).fastPut((Object)subKey, (Object)this.serializerString(value));
    }

    public void putLong(KeyGenerator generator, String subKey, Long value) {
        if (generator == null || null == value) {
            return;
        }
        this.numericHashOperations(generator).put((Object)subKey, (Object)value);
    }

    public <T> void putAll(KeyGenerator generator, Map<String, T> values) {
        if (values == null) {
            return;
        }
        HashMap convertResult = Maps.newHashMap();
        values.forEach((key, value) -> convertResult.put(key, this.serializerString(value)));
        this.hashOperations(generator).putAll((Map)convertResult);
    }

    public Long getLong(KeyGenerator generator, String subKey) {
        String value = (String)this.numericHashOperations(generator).get((Object)subKey);
        if (null == value) {
            return 0L;
        }
        return NumberUtils.parseToLong((String)value);
    }

    public <T> T get(KeyGenerator generator, String subKey, Class<T> classes) {
        String value = (String)this.hashOperations(generator).get((Object)subKey);
        if (null == value) {
            return null;
        }
        return this.deSerializerString(value, classes, null);
    }

    public <T> T get(KeyGenerator generator, String subKey, TypeReference<T> typeReference) {
        String value = (String)this.hashOperations(generator).get((Object)subKey);
        if (null == value) {
            return null;
        }
        return this.deSerializerString(value, null, typeReference);
    }

    public Set<String> keys(KeyGenerator generator) {
        return this.hashOperations(generator).readAllKeySet();
    }

    public <T> List<T> values(KeyGenerator generator, Class<T> clasz) {
        Collection collection = this.hashOperations(generator).readAllValues();
        return collection.stream().map(item -> this.deSerializerString((String)item, clasz, null)).collect(Collectors.toList());
    }

    public <T> List<T> values(KeyGenerator generator, TypeReference<T> typeReference) {
        Collection collection = this.hashOperations(generator).readAllValues();
        return collection.stream().map(item -> this.deSerializerString((String)item, null, typeReference)).collect(Collectors.toList());
    }

    public <T> List<T> multiGet(KeyGenerator generator, Collection<String> subKeys, Class<T> clasz) {
        return subKeys.stream().map(item -> {
            String value = (String)this.hashOperations(generator).get(item);
            if (null == value) {
                return null;
            }
            return this.deSerializerString(value, clasz, null);
        }).collect(Collectors.toList());
    }

    public <T> List<T> multiGet(KeyGenerator generator, Collection<String> subKeys, TypeReference<T> typeReference) {
        return subKeys.stream().map(item -> {
            String value = (String)this.hashOperations(generator).get(item);
            if (null == value) {
                return null;
            }
            return this.deSerializerString(value, null, typeReference);
        }).collect(Collectors.toList());
    }

    public <T> Map<String, T> entries(KeyGenerator generator, Class<T> clasz) {
        return this.getEntries(generator, clasz, null);
    }

    public <T> Map<String, T> entries(KeyGenerator generator, TypeReference<T> typeReference) {
        return this.getEntries(generator, null, typeReference);
    }

    private <T> Map<String, T> getEntries(KeyGenerator generator, Class<T> clasz, TypeReference<T> typeReference) {
        Map map = this.hashOperations(generator).readAllMap();
        HashMap result = new HashMap();
        map.forEach((key, value) -> result.put(key, this.deSerializerString((String)value, clasz, typeReference)));
        return result;
    }

    public Boolean exists(KeyGenerator generator, String subKey) {
        return this.hashOperations(generator).containsKey((Object)subKey);
    }

    public Long remove(KeyGenerator generator, String ... subKeys) {
        if (ArrayUtils.isEmpty((Object[])subKeys)) {
            return 0L;
        }
        return this.hashOperations(generator).fastRemove((Object[])subKeys);
    }

    public Long length(KeyGenerator generator) {
        return this.hashOperations(generator).size();
    }

    public Long increment(KeyGenerator generator, String subKey, int amount) {
        Object value = this.numericHashOperations(generator).addAndGet((Object)subKey, (Number)amount);
        if (null == value) {
            return 0L;
        }
        return Long.valueOf(value.toString());
    }
}

