/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.redisson.impl;

import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.entity.TypedTuple;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisZSetAdapter;
import com.bxm.newidea.component.redisson.config.SwitchMultiDataSourceHandler;
import com.bxm.newidea.component.redisson.impl.BaseRedisAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.redisson.api.RScoredSortedSet;
import org.redisson.api.RSortedSet;
import org.redisson.client.protocol.ScoredEntry;

public class RedissonZSetAdapterImpl
extends BaseRedisAdapter
implements RedisZSetAdapter {
    public RedissonZSetAdapterImpl(SwitchMultiDataSourceHandler switchMultiDataSourceHandler) {
        super(switchMultiDataSourceHandler);
    }

    private RSortedSet zsetOperations(KeyGenerator keyGenerator) {
        return this.switchMultiDataSourceHandler.getRedissonClient(keyGenerator.getDbName()).getSortedSet(keyGenerator.gen());
    }

    private RScoredSortedSet scoredSortedSetOperations(KeyGenerator keyGenerator) {
        return this.switchMultiDataSourceHandler.getRedissonClient(keyGenerator.getDbName()).getScoredSortedSet(keyGenerator.gen());
    }

    public Boolean add(KeyGenerator generator, Object value, double score) {
        if (value instanceof String) {
            return this.scoredSortedSetOperations(generator).add(score, (Object)value.toString());
        }
        return this.scoredSortedSetOperations(generator).add(score, (Object)this.serializerString(value));
    }

    public Long add(KeyGenerator generator, Set<TypedTuple> tuples) {
        return this.scoredSortedSetOperations(generator).addAll(this.serialize(tuples));
    }

    private Map<String, Double> serialize(Set<TypedTuple> tuples) {
        HashMap<String, Double> map = new HashMap<String, Double>((int)((float)tuples.size() / 0.75f) + 1);
        for (TypedTuple next : tuples) {
            if (next.getValue() instanceof String) {
                map.put(next.getValue().toString(), next.getScore());
                continue;
            }
            map.put(JSON.toJSONString((Object)next.getValue()), next.getScore());
        }
        return map;
    }

    public <T> Double incrementScore(KeyGenerator generator, T value, double amount) {
        if (value instanceof String) {
            return this.scoredSortedSetOperations(generator).addScore((Object)value.toString(), (Number)amount);
        }
        return this.scoredSortedSetOperations(generator).addScore((Object)this.serializerString(value), (Number)amount);
    }

    public <T> Long remove(KeyGenerator generator, Object ... values) {
        AtomicLong atomicLong = new AtomicLong();
        for (Object value : values) {
            boolean remove = this.scoredSortedSetOperations(generator).remove((Object)this.serializerString(value));
            atomicLong.addAndGet(remove ? 1L : 0L);
        }
        return atomicLong.get();
    }

    public Long removeByRange(KeyGenerator generator, long start, long end) {
        return this.scoredSortedSetOperations(generator).removeRangeByRank((int)start, (int)end);
    }

    public Long removeByScore(KeyGenerator generator, double min, double max) {
        return this.scoredSortedSetOperations(generator).removeRangeByScore(min, true, max, true);
    }

    public Long size(KeyGenerator generator) {
        return this.scoredSortedSetOperations(generator).size();
    }

    public Long count(KeyGenerator generator, double min, double max) {
        return this.scoredSortedSetOperations(generator).count(min, true, max, true);
    }

    public <T> Long rank(KeyGenerator generator, T value) {
        return (long)this.scoredSortedSetOperations(generator).rank((Object)this.serializerString(value));
    }

    public <T> Long reverseRank(KeyGenerator generator, T value) {
        return (long)this.scoredSortedSetOperations(generator).revRank((Object)this.serializerString(value));
    }

    public <T> Double score(KeyGenerator generator, T value) {
        return this.scoredSortedSetOperations(generator).getScore((Object)this.serializerString(value));
    }

    public <T> Set<TypedTuple<T>> rangeByScoreWithScores(KeyGenerator generator, double min, double max, long offset, long count, boolean isReversed, Class<T> clasz) {
        Collection result = isReversed ? this.scoredSortedSetOperations(generator).entryRangeReversed(min, true, max, true, (int)offset, (int)count) : this.scoredSortedSetOperations(generator).entryRange(min, true, max, true, (int)offset, (int)count);
        return this.deserializeTuple(Objects.requireNonNull(result), clasz);
    }

    private <T> Set<TypedTuple<T>> deserializeTuple(Collection<ScoredEntry<T>> tuples, Class<T> clasz) {
        LinkedHashSet<TypedTuple<T>> result = new LinkedHashSet<TypedTuple<T>>();
        if (null == tuples) {
            return result;
        }
        for (ScoredEntry<T> tuple : tuples) {
            result.add(new TypedTuple(this.deSerializerString(tuple.getValue().toString(), clasz, null), tuple.getScore()));
        }
        return result;
    }

    public <T> Set<TypedTuple<T>> rangeByScoreWithScores(KeyGenerator generator, double min, double max, boolean isReversed, Class<T> clasz) {
        Collection result = isReversed ? this.scoredSortedSetOperations(generator).entryRangeReversed(min, true, max, true) : this.scoredSortedSetOperations(generator).entryRange(min, true, max, true);
        return this.deserializeTuple(Objects.requireNonNull(result), clasz);
    }

    public <T> Set<T> range(KeyGenerator generator, long start, long end, boolean isReversed, Class<T> clasz) {
        Collection result = new ArrayList();
        result = isReversed ? this.scoredSortedSetOperations(generator).valueRangeReversed((int)start, (int)end) : this.scoredSortedSetOperations(generator).valueRange((int)start, (int)end);
        return this.listToSet(result, clasz);
    }

    private <T> Set<T> listToSet(Collection<String> result, Class<T> clasz) {
        LinkedHashSet<T> set = new LinkedHashSet<T>();
        for (String str : result) {
            set.add(this.deSerializerString(str, clasz, null));
        }
        return set;
    }

    public <T> Set<TypedTuple<T>> rangeWithScores(KeyGenerator generator, long start, long end, Class<T> clasz) {
        Collection result = this.scoredSortedSetOperations(generator).entryRange((int)start, (int)end);
        return this.deserializeTuple(result, clasz);
    }

    public <T> Set<T> rangeByScore(KeyGenerator generator, double min, double max, boolean isReversed, Class<T> clasz) {
        Collection result = isReversed ? this.scoredSortedSetOperations(generator).valueRangeReversed(min, true, max, true) : this.scoredSortedSetOperations(generator).valueRange(min, true, max, true);
        return this.stringToSet(result, clasz);
    }

    private <T> Set<T> stringToSet(Collection<String> result, Class<T> clasz) {
        LinkedHashSet<T> set = new LinkedHashSet<T>();
        for (String str : result) {
            set.add(this.deSerializerString(str, clasz, null));
        }
        return set;
    }

    private <T> Set<T> scoredEntryToSet(Collection<ScoredEntry<T>> result, Class<T> clasz) {
        LinkedHashSet<T> set = new LinkedHashSet<T>();
        for (ScoredEntry<T> tScoredEntry : result) {
            set.add(this.deSerializerString(tScoredEntry.getValue().toString(), clasz, null));
        }
        return set;
    }

    public <T> Set<T> rangeByScore(KeyGenerator generator, double min, double max, long offset, long count, boolean isReversed, Class<T> clasz) {
        Collection result = isReversed ? this.scoredSortedSetOperations(generator).valueRangeReversed(min, true, max, true, (int)offset, (int)count) : this.scoredSortedSetOperations(generator).valueRange(min, true, max, true, (int)offset, (int)count);
        return this.stringToSet(result, clasz);
    }

    public Long intersectAndStore(KeyGenerator target, KeyGenerator source, KeyGenerator ... otherKeys) {
        String[] strings = (String[])this.convertKeys(source, otherKeys).stream().toArray(String[]::new);
        return this.scoredSortedSetOperations(target).intersection(strings);
    }

    public Long unionAndStore(KeyGenerator target, KeyGenerator source, KeyGenerator ... otherKeys) {
        return this.scoredSortedSetOperations(target).union((String[])this.convertKeys(source, otherKeys).stream().toArray(String[]::new));
    }
}

