/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.redisson.impl;

import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.redisson.impl.BaseRedisAdapter;
import com.bxm.newidea.component.tools.NumberUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RAtomicDouble;
import org.redisson.api.RBucket;
import org.redisson.api.RTopic;
import org.redisson.api.RedissonClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RedissonStringAdapterImpl
extends BaseRedisAdapter
implements RedisStringAdapter {
    @Autowired
    public RedissonStringAdapterImpl(RedissonClient redissonClient) {
        super(redissonClient);
    }

    private RBucket<String> stringOperations(KeyGenerator generator) {
        return this.redissonClient.getBucket(generator.gen());
    }

    private RTopic topOperations(String key) {
        return this.redissonClient.getTopic(key);
    }

    private RAtomicDouble doubleOperations(KeyGenerator generator) {
        return this.redissonClient.getAtomicDouble(generator.gen());
    }

    public Long increment(KeyGenerator generator) {
        return this.increment(generator, 1);
    }

    public Long increment(KeyGenerator generator, int amount) {
        return this.incrementWithDefault(generator, 1L, amount, 0L);
    }

    public Long increment(KeyGenerator generator, long expireSeconds) {
        return this.incrementWithDefault(generator, 1L, 1, expireSeconds);
    }

    public Long incrementWithDefault(KeyGenerator generator, long defaultVal) {
        return this.incrementWithDefault(generator, defaultVal, 1, 0L);
    }

    public Long incrementWithDefault(KeyGenerator generator, long defaultVal, int amount) {
        return this.incrementWithDefault(generator, defaultVal, amount, 0L);
    }

    public Long incrementWithDefault(KeyGenerator generator, long defaultVal, int amount, long expireSeconds) {
        return this.exec(generator, defaultVal, amount, expireSeconds, true).longValue();
    }

    public Long decrement(KeyGenerator generator, long defaultVal, int amount, long expireSeconds) {
        return this.exec(generator, defaultVal, amount, expireSeconds, false).longValue();
    }

    public Long decrement(KeyGenerator generator) {
        return this.decrement(generator, 1L, 1, 0L);
    }

    public Long decrement(KeyGenerator generator, int amount) {
        return this.decrement(generator, 1L, amount, 0L);
    }

    public Long decrement(KeyGenerator generator, long expireSeconds) {
        return this.decrement(generator, 1L, 1, expireSeconds);
    }

    public Long decrement(KeyGenerator generator, long defaultVal, int amount) {
        return this.decrement(generator, defaultVal, amount, 0L);
    }

    public Long getLong(KeyGenerator generator) {
        return NumberUtils.parseToLong((String)this.getString(generator));
    }

    public Integer getInt(KeyGenerator generator) {
        return NumberUtils.parseToInt((String)this.getString(generator));
    }

    public String getString(KeyGenerator generator) {
        String value = (String)this.stringOperations(generator).get();
        if (null == value) {
            return "";
        }
        return value;
    }

    public <T> T get(KeyGenerator generator, Class<T> clasz) {
        String value = (String)this.stringOperations(generator).get();
        if (null == value) {
            return null;
        }
        return this.deSerializerString(value, clasz, null);
    }

    public <T> T get(KeyGenerator generator, TypeReference<T> typeReference) {
        String value = (String)this.stringOperations(generator).get();
        if (null == value) {
            return null;
        }
        return this.deSerializerString(value, null, typeReference);
    }

    public <T> void set(KeyGenerator generator, T value) {
        this.stringOperations(generator).set((Object)this.serializerString(value));
    }

    public void set(KeyGenerator generator, long value) {
        this.stringOperations(generator).set((Object)this.serializerString(value));
    }

    public <T> void set(KeyGenerator generator, T value, long expireSeconds) {
        if (value instanceof String) {
            this.stringOperations(generator).set((Object)value.toString(), expireSeconds, TimeUnit.SECONDS);
        } else {
            this.stringOperations(generator).set((Object)this.serializerString(value), expireSeconds, TimeUnit.SECONDS);
        }
    }

    public void set(KeyGenerator generator, Double value) {
        this.stringOperations(generator).set((Object)this.serializerString(value));
    }

    public Double increment(KeyGenerator generator, double amount) {
        return this.increment(generator, amount, amount, 0L);
    }

    public Double increment(KeyGenerator generator, double defaultVal, double amount, long expireSeconds) {
        return this.exec(generator, defaultVal, amount, expireSeconds, true);
    }

    public Double decrement(KeyGenerator generator, double amount) {
        return this.decrement(generator, 0.0, amount, 0L);
    }

    public Double decrement(KeyGenerator generator, double defaultVal, double amount, long expireSeconds) {
        return this.exec(generator, defaultVal, amount, expireSeconds, false);
    }

    public void convertAndSend(String channel, Object message) {
        this.topOperations(channel).publish(message);
    }

    private Double exec(KeyGenerator generator, double defaultVal, double amount, long expireSeconds, boolean isIncrement) {
        if (!this.hasKey(generator).booleanValue()) {
            if (expireSeconds > 0L) {
                this.stringOperations(generator).set((Object)this.serializerString(defaultVal), expireSeconds, TimeUnit.SECONDS);
            } else {
                this.stringOperations(generator).set((Object)this.serializerString(defaultVal));
            }
            return defaultVal;
        }
        amount = isIncrement ? amount : -amount;
        return this.doubleOperations(generator).addAndGet(amount);
    }
}

